<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title><?php echo e($title2); ?></title>
    <style type="text/css">
        .page-break {
            page-break-after: always;
        }
        .header{
            text-align: center;
            align-items: center;
        }
        h1{
            padding: 0;
            margin: 0;
        }
        table{
            width: 100%;
            border-collapse: collapse;
        }
        table td, th {
            border: 1px solid black;
            text-align: center;
        }
        .text-right{
            text-align: right !important;
        }
        .text-left{
            text-align: left !important;
        }
        footer {
            position: fixed;
            bottom: -10px;
            left: 0px;
            right: 0px;
            height: 1px;
        }
        .footer-inner {
            position: absolute;
            bottom: 40px;
            width: 100%;
        }
        .text-bold{
            font-weight: 600;
            color: green;
        }
    </style>
</head>
<body>
    <div class="main_container">
        <div class="header">
            <img src="<?php echo e(asset('backend/app-assets/images/logo/worldwise_shaglobal.jpeg')); ?>" width="100">
            
            <?php if(isset($date_show)): ?>
            <span><?php echo e($date_show); ?></span>
            <?php endif; ?>


        </div>
        <h2 style="margin-bottom: 5px !important; margin-bottom: 5px !important; padding-bottom: 5px !important" align="center"><?php echo e($title2); ?>: </h2>
        <h2 style="font-size: 15px;" align="center">Name:  <?php echo e($user->name); ?> </h2>
        <div class="page_break">
            <div class="test_details" style="margin-top: 10px;">
                <table>
                    <thead>
                        <tr>
                            <th>ID</th>            
                            <th>Type</th>
                            <th>Application Date</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Days</th>
                            <th>Reason</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($leave_application): ?>
                            <?php $__currentLoopData = $leave_application; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $start_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->start_date);
                                $end_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->end_date);
                                $diff_in_days = (($start_date->diffInDays($end_date) + 1) > 0)? ($start_date->diffInDays($end_date) + 1) : 1 ;
                            ?>
                            <tr>
                                <th><?php echo e(++$key); ?></th>         
                                <td>
                                    <?php if($list->type == 1): ?>
                                    Medical Leave
                                    <?php elseif($list->type == 2): ?>
                                    Personal Leave
                                    <?php elseif($list->type == 3): ?>
                                    Holiday Leave
                                    <?php elseif($list->type == 4): ?>
                                    Emergency Leave
                                    <?php else: ?>
                                    ---
                                    <?php endif; ?>
                                </td>
    
                                <td><?php echo e(date('d M y', strtotime($list->application_date))); ?></td>
                                <td><?php echo e(date('d M Y', strtotime($list->start_date))); ?></td>
                                <td><?php echo e(date('d M Y', strtotime($list->end_date))); ?></td>
                                <td><?php echo e($diff_in_days); ?> Days</td>
                                <td><?php echo e($list->reason); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!--Footer-->
        <footer id="footer">
            <div class="footer-inner">
                <hr style="width: 200px;margin-left: 0;background: black;" size="1"/>
                <span style="margin-left: 50px;">Manager Signature</span>
            </div>
            <div align="right">

            <small style="text-align: right; font-size: 10px; font-family: monospace;">print date: <?php echo e(\Carbon\Carbon::now()); ?></small>
            </div>
        </footer>
    </div>
</body>
</html><?php /**PATH /home/shagmtco/urportals.com/resources/views/pages/report/print/holiday_report_print.blade.php ENDPATH**/ ?>