<?php $__env->startPush('css'); ?>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<style type="text/css">
    label{
        font-weight: 600;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
    <div class="content-header row">
    </div>
    <div class="content-body">
        <!-- Dashboard Ecommerce Starts -->
        <section id="dashboard-ecommerce">
            <form method="GET" id="filterForm">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-2">
                                <input type="text" class="form-control" name="daterange" id="daterange" placeholder="Enter Date range" value="<?php echo e(($request->daterange)?: ''); ?>" />
                            </div>
                            <div class="col-md-2">
                                <select class="form-control form-control-sm select2" name="user_id" required>
                                    <option value="">Select Employee</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"<?php echo e(($request->user_id == $user->id)? 'selected' : ''); ?>><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <input type="hidden" name="sub_type" id="sub_type" value="">
                            <div class="">
                                <div class="form-inline">
                                    <button onclick="formSubmit(1)" type="button" class="btn btn-success"><i class="fa fa-search"></i></button>
                                    <button type="button" onclick="formSubmit(2)" class="btn btn-primary" style="margin-left: 5px;">Sign In/Out Reports</button>
                                    <button type="button" onclick="formSubmit(3)" class="btn btn-warning" style="margin-left: 5px;">Holiday Reports</button>
                                    &nbsp;

                                    <?php if(Auth::user()->role == 1 || Auth::user()->role == 4): ?>         
                                    <button type="button" onclick="return addSignIn()" class="btn btn-success">Employee Signin</i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            <div class="row" style="margin-top: 10px;">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">Task</div>
                        <div class="card-body table-responsive">
                            <table class="table table-bordered table-striped table-hover-animation">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Employee Name</th>
                                        <th>Sign In</th>
                                        <th>Sign Out</th>
                                        <th>Break Time</th>
                                        <th>Total Hour</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $hours = '1';
                                        $minutes = '2';
                                    ?>
                                    <?php $__currentLoopData = $sign_in_out_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                                    
                                    <tr>
                                        <td><?php echo e(++$key); ?></td>
                                        <td><?php echo e($list->user->name); ?></td>                 
                                        <td><?php echo e(($list->sign_in)? \Carbon\Carbon::parse($list->sign_in)->format('d M Y, h:i a') : '-- -- -- --'); ?></td>
                                        <td><?php echo e(($list->sign_out)? \Carbon\Carbon::parse($list->sign_out)->format('d M Y, h:i a') : '-- -- -- --'); ?></td>
                                        <td>
                                            <?php if($list->break_time): ?>
                                                <?php
                                                    $date_arr = explode(":", $list->break_time);          if( isset($date_arr[0]) ){
                                                        $hours = $date_arr[0];
                                                        echo $date_arr[0]." : ";
                                                    }                        
                                                    if( isset($date_arr[1]) ){
                                                        $minutes = $date_arr[1];
                                                        echo $date_arr[1]."  Hours";
                                                    }
                                                ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($list->sign_in && $list->sign_out): ?>
                                                <?php if($list->break_time): ?>
                                                    <?php $start = \Carbon\Carbon::parse($list->sign_in)->addMinutes($minutes)->addHours($hours) ?>
                                                <?php else: ?>
                                                    <?php $start = \Carbon\Carbon::parse($list->sign_in); ?>
                                                <?php endif; ?>
                                                <?php
                                                    $end = \Carbon\Carbon::parse($list->sign_out);
                                                    $totalDuration =  $start->diff($end)->format('%H');
                                                    $minute =  $start->diff($end)->format('%i');
                                                ?>
                                                <?php echo e(($totalDuration > 0)? $totalDuration.' Hours' : ''); ?>

                                                <?php echo e(($minute > 0)? $minute.' Minutes' : ''); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td> 
                                            <?php if(Auth::user()->role == 1 || Auth::user()->role == 4): ?>         
                                                <button type="button" onclick="return editData( <?php echo e(json_encode($list)); ?> )" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i>
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>                                    
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <div class="paginate" style="float: right; margin-top: 10px;">
                                <?php echo $sign_in_out_reports->links(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Dashboard Ecommerce ends -->
        <!-- Add Sign-in/Sign-out -->
         <div class="modal fade" id="add-sign-in-out" role="dialog" aria-labelledby="add-sign-in-out" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="add-sign-in-out">Add Sign-in/Sign-out</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="<?php echo e(url('add-sign-in-out-by-admin')); ?>" >
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <select class="form-control form-control select2" name="sign_user_id" required>
                                        <option value="">Select Employee</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>"<?php echo e(($request->user_id == $user->id)? 'selected' : ''); ?>><?php echo e($user->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label>Signin Date & Time <span class="required">*</span></label>                                   
                                    <input type="datetime-local" id="sign_in"  name="sign_in" class="form-control" required>
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label>Signout Date & Time <span class="required">*</span></label>                 
                                    <input type="datetime-local" id="sign_out"  name="sign_out" class="form-control" required>
                                </div>
                            </div>
                             <div class="modal-header">
                                <h5 class="modal-title" >Add Break Time</h5>                            
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label>Hours</label>
                                    <select class="form-control" name="hour" >
                                        <option value="">Select Hour</option>
                                        <?php for($i=0; $i<13; $i++): ?>
                                        <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Minute</label>
                                    <select class="form-control" name="minute">
                                        <option value="">Select Minute</option>
                                        <?php for($i=0; $i<61; $i++): ?>
                                        <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                        </div> 
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- Update Sign-in/Sign-out -->
         <div class="modal fade" id="sign-in-out" role="dialog" aria-labelledby="sign-in-out" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="sign-in-out">Update Sign-in/Sign-out</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(url('sign-in-out')); ?> ">
                        <div class="modal-body">
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label>Signin Date & Time <span class="required">*</span></label>
                                    <input type="datetime" id="sign_in_readony" name="sign_in_readony" readonly class="form-control">
                                    <input type="datetime-local" id="sign_in"  name="sign_in" class="form-control" required>
                                </div>
                                <div class="col-md-6">
                                    <label>Signout Date & Time <span class="required">*</span></label>
                                    <input type="datetime" id="sign_out_readony" name="sign_out_readony" readonly class="form-control" >
                                    <input type="datetime-local" id="sign_out"  name="sign_out" class="form-control" required>
                                </div>
                            </div>
                            <div class="modal-header">
                                <h5 class="modal-title" id="sign-in-out">Update Break Time</h5>                            
                            </div>
                            <div class="form-group row">
                                <div class="col-md-6">
                                    <label>Hours</label>
                                    <select class="form-control" name="hour" id="hour" >
                                        <option value="">Select Hour</option>
                                        <?php for($i=0; $i<13; $i++): ?>
                                        <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Minute</label>
                                    <select class="form-control" name="minute" id="minute" >
                                        <option value="">Select Minute</option>
                                        <?php for($i=0; $i<61; $i++): ?>
                                        <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="sign_in_id" id="sign_in_id">
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript">
    function editData(value){ 
        var break_time = value.break_time;        
        $('#sign-in-out').modal('show');
        $('#sign_in_id').val(value.id);
        $('#sign_in_readony').val(value.sign_in);
        $('#sign_out_readony').val(value.sign_out);   
        if(break_time){
            var break_time_split = break_time.split(":");
            $('#hour').val(break_time_split[0]); 
            $('#minute').val(break_time_split[1]);  
        } 
             
    }
    function addSignIn(){        
        $('#add-sign-in-out').modal('show');             
    }    
    $(document).ready(function() {        
        $('#daterange').daterangepicker({
            autoUpdateInput: false,
            locale: {
                cancelLabel: 'Clear'
            }
        });
    });
    $('#daterange').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
    });

    $('#daterange').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });


    function formSubmit(type){
        if(type == 1){
            $('#filterForm').attr('target', '')
            $('#sub_type').val('')
        }else if(type == 2){
            $('#filterForm').attr('target', '_blank');
            $('#sub_type').val('sign-in-out-export');
        }else if(type == 3){
            $('#filterForm').attr('target', '_blank');
            $('#sub_type').val('holiday-export');
        }
        else{
            $('#filterForm').attr('target', '')
            $('#sub_type').val('')
        }
        
        $('#filterForm').submit();
    }

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shagmtco/urportals.com/resources/views/pages/report/sign_in_out_report.blade.php ENDPATH**/ ?>