<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title><?php echo e($title); ?></title>
    <style type="text/css">
        .page-break {
            page-break-after: always;
        }
        .header{
            text-align: center;
            align-items: center;
        }
        h1{
            padding: 0;
            margin: 0;
        }
        table{
            width: 100%;
            border-collapse: collapse;
        }
        table td, th {
            border: 1px solid black;
            text-align: center;
        }
        .text-right{
            text-align: right !important;
        }
        .text-left{
            text-align: left !important;
        }
        footer {
            position: fixed;
            bottom: -10px;
            left: 0px;
            right: 0px;
            height: 1px;
        }
        .footer-inner {
            position: absolute;
            bottom: 40px;
            width: 100%;
        }
        .text-bold{
            font-weight: 600;
            color: green;
        }
    </style>
</head>
<body>
    <div class="main_container">
        <div class="header">
            <img src="<?php echo e(asset('backend/app-assets/images/logo/worldwise_shaglobal.jpeg')); ?>" width="100">
            
            <?php if(isset($date_show)): ?>
            <span><?php echo e($date_show); ?></span>
            <?php endif; ?>


        </div>
        <h2 style="margin-bottom: 5px !important; margin-bottom: 5px !important; padding-bottom: 5px !important" align="center"><?php echo e($title); ?>: </h2>
        <h2 style="font-size: 15px;" align="center">Name:  <?php echo e($user->name); ?> </h2>
        <div class="page_break">
            <div class="test_details" style="margin-top: 10px;">
                <table>
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>Sign In</th>
                        <th>Sign Out</th>
                        <th>Break Time</th>
                        <th>Total Hour</th>
                    </tr>
                    <?php 
                        $totalReportHour = 0; 
                        $totalReportMinutes = 0;
                    ?>
                    
                    <?php $__currentLoopData = $sign_in_out_reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                    
                    <tr>
                        <td><?php echo e(++$key); ?></td>                       
                        <td><?php echo e(($list->date)? \Carbon\Carbon::parse($list->sign_in)->format('d M y') : '-- --'); ?></td>
                        <td><?php echo e(($list->sign_in)? \Carbon\Carbon::parse($list->sign_in)->format('h:i a') : '-- -- -- --'); ?></td>
                        <td><?php echo e(($list->sign_out)? \Carbon\Carbon::parse($list->sign_out)->format('h:i a') : '-- -- -- --'); ?></td>
                        <td>
                            <?php if($list->break_time): ?>
                                <?php
                                    $date_arr = explode(":", $list->break_time);          if( isset($date_arr[0]) ){
                                        $hours = $date_arr[0];
                                        echo $date_arr[0]." : ";
                                    }                        
                                    if( isset($date_arr[1]) ){
                                        $minutes = $date_arr[1];
                                        echo $date_arr[1]."  Hours";
                                    }
                                ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($list->sign_in && $list->sign_out): ?>                            
                                <?php if($list->break_time): ?>
                                    <?php $start = \Carbon\Carbon::parse($list->sign_in)->addMinutes($minutes)->addHours($hours) ?>
                                <?php else: ?>
                                    <?php $start = \Carbon\Carbon::parse($list->sign_in); ?>
                                <?php endif; ?>
                                <?php
                                    $end = \Carbon\Carbon::parse($list->sign_out);
                                    $totalDuration =  $start->diff($end)->format('%H');
                                    $minute =  $start->diff($end)->format('%i');
                                    $totalReportHour = $totalReportHour + $totalDuration;
                                    $totalReportMinutes = $totalReportMinutes + $minute;
                                ?>
                                <?php echo e(($totalDuration > 0)? $totalDuration.' Hours' : ''); ?>

                                <?php echo e(($minute > 0)? $minute.' Minutes' : ''); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td> </td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="font-weight: bold;">Total Working Hours: </td>
                        <td>
                            <?php
                                $reportRemainMinutes = ( $totalReportMinutes % 60 );                                    
                                $totalReportMinutes = $totalReportMinutes - $reportRemainMinutes;
                                $totalReportHour = $totalReportHour + ( $totalReportMinutes/60);
                            ?>
                            <?php echo e($totalReportHour); ?> Hours<br/>
                            <?php echo e($reportRemainMinutes); ?> Minutes
                        </td>
                    </tr>
                    
                </table>
            </div>
        </div>

        <!--Footer-->
        <footer id="footer">
            <div class="footer-inner">
                <hr style="width: 200px;margin-left: 0;background: black;" size="1"/>
                <span style="margin-left: 50px;">Manager Signature</span>
            </div>
            <div align="right">

            <small style="text-align: right; font-size: 10px; font-family: monospace;">print date: <?php echo e(\Carbon\Carbon::now()); ?></small>
            </div>
        </footer>
    </div>
</body>
</html><?php /**PATH /home/shagmtco/urportals.com/resources/views/pages/report/print/sign_in_out_report_print.blade.php ENDPATH**/ ?>