
<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

Route::get('/', function(){	
    return redirect('/login');
});

Route::get('/logout', function(){
    return redirect('/login');
});


Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

//Employee

Route::middleware(['auth'])->group(function(){
	// employee section
	Route::resource('employee','EmployeeController');
	Route::post('employee-update','EmployeeController@update');

	//Leave Application
	Route::resource('leave-application','Hris\LeaveApplicationController');
	Route::post('leave-application-update','Hris\LeaveApplicationController@update');
	Route::get('leave-application-notification','Hris\LeaveApplicationController@leave_notify');

	// departments section
	Route::resource('departments','Setting\DepartmentControiller');
	Route::post('departments-update','Setting\DepartmentControiller@update');

	//task releated 
	Route::resource('tasks','TaskController');
	Route::post('tasks-update','TaskController@update');
	Route::post('task-feedback','TaskController@task_feedback');
	Route::get('get-feedback-data-by-task-id','TaskController@get_feedback_data_by_task_id');
	Route::get('tasks-docs-destroy','TaskController@tasks_docs_destroy');

	// project section
	Route::resource('project','Setting\ProjectController');
	Route::post('project-update','Setting\ProjectController@update');

	// designation section
	Route::resource('designation','Setting\DesignationController');
	Route::post('designation-update','Setting\DesignationController@update');

	// uploads_docs section
	Route::resource('uploads_docs','Setting\EmployeeDocController');
	Route::post('uploads_docs-update','Setting\EmployeeDocController@update');

	Route::resource('warning_letter','WarninLetterController');
	// Route::post('uploads_docs-update','EmployeeDocController@update');

	//profile releated
	Route::get('profiles','HomeController@profile');
	Route::post('general-info-update','HomeController@general_info_update');
	Route::post('change-password','HomeController@change_password');
	Route::post('employee-info-update','HomeController@employee_info_update');


	Route::get('sign-in-out/{id?}','HomeController@sign_in_out');
	Route::get('sign-in-out-report','HomeController@sign_in_out_report');

	Route::get('over-due-tasks', 'Report\ReportController@over_due_tasks');

	//sticky note
	Route::post('sticky-note-update','HomeController@sticky_note_update');

	//notice board
	Route::resource('notice-board','NoticeBoardController');
	Route::post('notice-board-update','NoticeBoardController@update');
	
});

//to clear all cache
Route::get('__clear',function(){
    try{
        // \Artisan::call('optimize');
        \Artisan::call('clear-compiled');
        \Artisan::call('cache:clear');
        \Artisan::call('view:clear');
        \Artisan::call('config:clear');
        \Artisan::call('config:cache');
        \Artisan::call('queue:restart');
    }
    catch(\Exception $e){
        echo $e->getMessage();
    }
});
