@php
    $due_tasks = (Auth::user()->employee->unread_tasks)? Auth::user()->employee->unread_tasks->count() : 0;

    $leave_application_notify = \App\Models\LeaveApplication::orderBy('id','desc');
    if(Auth::user()->role == 1 || Auth::user()->role == 3 || Auth::user()->role == 4){
        if(Auth::user()->role == 3){
            $dep_ids = (Auth::user()->dep_employees)? Auth::user()->dep_employees->pluck('id') : [];
            $leave_application_notify = $leave_application_notify->where('dp_status', 1)->whereIn('emp_id', $dep_ids);
        }else{
            $leave_application_notify = $leave_application_notify->where('hr_status', 1);
        }
        $leave_application_notify = $leave_application_notify->count();
    }else{
        $leave_application_notify = 0;
    }
    $total_notify = $due_tasks + $leave_application_notify;
@endphp

<nav class="header-navbar navbar-expand-lg navbar navbar-with-menu navbar-fixed navbar-shadow navbar-brand-center">
        <div class="navbar-header d-xl-block d-none">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item"><a class="navbar-brand" href="{{url('/home')}}">
                        <img src="{{ asset('backend/app-assets/images/logo/worldwise_shaglobal.jpeg') }}" width="120">
                    </a></li>
            </ul>
        </div>
        <div class="navbar-wrapper">
            <div class="navbar-container content">
                <div class="navbar-collapse" id="navbar-mobile">
                    <div class="mr-auto float-left bookmark-wrapper d-flex align-items-center">
                        <ul class="nav navbar-nav">
                            <li class="nav-item mobile-menu d-xl-none mr-auto"><a class="nav-link nav-menu-main menu-toggle hidden-xs" href="#"><i class="ficon feather icon-menu"></i></a></li>
                        </ul>
                        @php
                            $sign_in_out = Auth::user()->current_day_sign_in_out;
                        @endphp
                        <ul class="nav navbar-nav bookmark-icons">
                            @if(empty($sign_in_out))                            
                            <a href="{{ url('sign-in-out') }}" onclick="return confirm('are you sure, you want yo do this? ')" class="btn btn-success btn-sm" style="color: #fff;">Signing In</a>
                            @endif
                            @if($sign_in_out && empty($sign_in_out->sign_out))
                            <span>Sign In: <b>{{ \Carbon\Carbon::parse($sign_in_out->sign_in)->format('h:i a') }}</b></span>
                            <button data-toggle="modal" data-target="#signOut" class="btn btn-danger btn-sm" style="color: #fff; margin-left: 5px;">Signing Out</a>
                            @endif
                            @if($sign_in_out && $sign_in_out->sign_in && $sign_in_out->sign_out)
                            <span>Sign In: <b>{{ \Carbon\Carbon::parse($sign_in_out->sign_in)->format('h:i a') }}</b></span>
                            <span style="margin-left: 10px;">Sign Out: <b>{{ \Carbon\Carbon::parse($sign_in_out->sign_out)->format('h:i a') }}</b></span>
                            @endif
                        </ul>
                    </div>
                    <ul class="nav navbar-nav float-right">
                        <li class="dropdown dropdown-notification nav-item"><a class="nav-link nav-link-label" href="#" data-toggle="dropdown"><i class="ficon feather icon-bell"></i><span class="badge badge-pill badge-primary badge-up">{{ ($total_notify)?: '' }}</span></a>
                            <ul class="dropdown-menu dropdown-menu-media dropdown-menu-right">
                                <li class="dropdown-menu-header">
                                    <div class="dropdown-header m-0 p-2">
                                        @if($total_notify)
                                        <h3 class="white">{{ $total_notify }} New</h3><span class="notification-title">App Notifications</span>
                                        @else
                                        You have No Notification Yet Now.. 
                                        @endif
                                    </div>
                                </li>
                                @if($total_notify)
                                <li class="scrollable-container media-list ps">
                                    @if($due_tasks)
                                    <a class="d-flex justify-content-between" href="{{ url('tasks?read_status=2') }}">
                                        <div class="media d-flex align-items-start">
                                            <div class="media-left">{{ $due_tasks }}</div>
                                            <div class="media-body">
                                                <h6 class="primary media-heading">Unread Task Notification</h6>
                                            </div>
                                        </div>
                                    </a>
                                    @endif
                                    @if($leave_application_notify)
                                    <a class="d-flex justify-content-between" href="{{ url('leave-application-notification') }}">
                                        <div class="media d-flex align-items-start">
                                            <div class="media-left">({{ $leave_application_notify }})</div>
                                            <div class="media-body">
                                                <h6 class="primary media-heading">Pending Leave Application</h6>
                                            </div>
                                        </div>
                                    </a>
                                    @endif
                                    <div class="ps__rail-x" style="left: 0px; bottom: 0px;">
                                        <div class="ps__thumb-x" tabindex="0" style="left: 0px; width: 0px;"></div>
                                    </div>
                                    <div class="ps__rail-y" style="top: 0px; right: 0px;">
                                        <div class="ps__thumb-y" tabindex="0" style="top: 0px; height: 0px;"></div>
                                    </div>
                                </li>
                                @endif
                            </ul>
                        </li>

                        <li class="dropdown dropdown-user nav-item">
                            <a class="dropdown-toggle nav-link dropdown-user-link" href="#" data-toggle="dropdown">
                                <div class="user-nav d-sm-flex d-none"><span class="user-name text-bold-600">{{ Auth::user()->name }}</span><span class="user-status">Available</span></div><span><img class="round" src="{{ asset('/uploads/user_profile/'.Auth()->user()->photo) }}" alt="{{ Auth::user()->name }}" height="40" width="40"></span>
                            </a>

                            <div class="dropdown-menu dropdown-menu-right">
                                <a class="dropdown-item" href="{{ url('profiles') }}"><i class="feather icon-user"></i> Edit Profile</a>
                                <a class="dropdown-item" href="{{ url('tasks') }}"><i class="feather icon-check-square"></i> Task</a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><i class="feather icon-power"></i> Logout</a>
                                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                                    @csrf
                                </form>
                            </div>

                            
                        </li>
                    </ul>
                </div>
            </div>
        </div>

    </nav>

    <!-- Modal -->
    <div class="modal fade" id="signOut" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Break Time</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ url('sign-in-out',( $sign_in_out)?  $sign_in_out->id : '') }}">
                    <div class="modal-body">
                        <div class="form-group row">
                            <div class="col">
                                <label>Hours</label>
                                <select class="form-control" name="hour" required="">
                                    <option value="">Select Hour</option>
                                    @for($i=0; $i<13; $i++)
                                    <option value="{{$i}}">{{$i}}</option>
                                    @endfor
                                </select>
                            </div>
                            <div class="col">
                                <label>Minute</label>
                                <select class="form-control" name="minute" required="">
                                    <option value="">Select Minute</option>
                                    @for($i=0; $i<61; $i++)
                                    <option value="{{$i}}">{{$i}}</option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

