@extends('layouts.master')
@section('content')
<style type="text/css">
    .col-6{
        margin-top: 10px;
    }
    .required{
        font-weight: 800;
        color: red;
    }
    label{
        font-weight: 600;
    }
    .btn-light{
        background-color: #156b53 !important;
    }

</style>
<div class="content-wrapper">

    <div class="content-body">
        <!-- Table Hover Animation start -->
        <div class="row" id="table-hover-animation">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $title }} List</h4>
                        <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
                            @if(Auth::user()->role == 1)
                            <button class="btn btn-info" data-toggle="modal" data-target="#large"><i class="fa fa-plus"></i> Add {{ $title }}</button>
                            @endif
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover-animation">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Title</th>
                                            <th>Date</th>
                                            @if(Auth::user()->role == 1)
                                            <th>Employee Name</th>
                                            @endif
                                            <th>Warning Letter</th>
                                            <th>Description</th>
                                            <th>Doc</th>
                                            @if(Auth::user()->role == 1)
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                    	@foreach($warning_letter as $key => $list)

                                        <tr onclick="return editData( {{json_encode($list)}} )" style="cursor: pointer;">
                                            <th>{{ ++$key }}</th>
                                            <td>{{ $list->title }}</td>
                                            <td>{{ $list->created_at }}</td>
                                            <td>Warning Letter {{ $list->warning_no }}</td>
                                            @if(Auth::user()->role == 1)
                                            <td>{{ $list->employee->name }}</td>
                                            @endif
                                            <td>{{ ($list->description)?: '---' }}</td>
                                        
                                            <td>
                                                @if($list->doc)
                                                <a href="{{ asset('storage/warning/'.$list->doc) }}" onclick="return confirm('are you sure?, you want to download it.');" download> {{ $list->doc_name }}</a>
                                                @else
                                                ---
                                                @endif
                                            </td>
                                            @if(Auth::user()->role == 1)
                                            <td>
                                            	<button type="button" class="btn btn-sm bg-gradient-danger" onclick="return deleteCertification(<?php echo $list->id; ?>)" title="delete"><i class="fa fa-trash-o"></i></button>
				                                <form id="delete-form-{{$list->id}}" action="{{ url('warning_letter',$list->id) }}" method="POST" style="display: none;">
				                                    @csrf
				                                    @method('DELETE')
				                                </form>
                                            </td>
                                            @endif
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="paginate" style="float: right;">
                                {!! $warning_letter->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table head options end -->

        <!-- Modal -->
        <div class="modal fade text-left" id="large" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel17">Add {{$title}}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('warning_letter') }}" enctype="multipart/form-data">
                    	@csrf
                        <div class="modal-body">
                            <div class="form-group">
                            	<label>Title <span class="required">*</span></label>
                            	<input type="text" name="name" class="form-control" placeholder="Enter Uploads Title" required="">
                            </div>
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" name="description" placeholder="Enter Uploads Description"></textarea>
                            </div>
                           
                            @if(Auth::user()->role == 2)
                           <input type="hidden" name="employee" value="{{ Auth::user()->employee->id }}">
                           @else
                            <div class="form-group">
                                <label>Select Employee <span class="required">*</span></label>
                                <select name="employee" class="form-control select2" required="">
                                    <option value="">Select Employee</option>
                                    @foreach($employess as $emp)
                                    <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif

                            <div class="form-group">
                               <label>Waring Letter No <span class="required"></span></label>
                               <select class="form-control" name="warning_no" required="">
                                   <option value="">Select Waring Number</option>
                                   @for($i = 1; $i < 4; $i++)
                                   <option value="{{$i}}">Warning Letter {{$i}}</option>
                                   @endfor
                               </select>
                            </div>
                            <div class="form-group">
                               <label>Status <span class="required"></span></label>
                               <select class="form-control" name="status" required="">
                                   <option value="1">Active</option>
                                   <option value="2">InActive</option>
                               </select>
                            </div>
                            <div class="form-group">
                                <label>File</label>
                                <input type="file" name="doc" class="form-control">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Edit Modal -->
        <div class="modal fade text-left" id="editModal" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel17">Update {{$title}}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('warning_letter-update') }}" enctype="multipart/form-data">
                    	@csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Title <span class="required">*</span></label>
                                <input type="text" id="name" name="name" class="form-control" {{(Auth::user()->role != 1)? 'readonly' : ''}} placeholder="Enter Uploads Title" required="">
                            </div>
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control" id="description" name="description" placeholder="Enter Uploads Description" {{(Auth::user()->role != 1)? 'readonly' : ''}}></textarea>
                            </div>
                           @if(Auth::user()->role == 2)
                           <input type="hidden" name="employee" value="{{ Auth::user()->employee->id }}">
                           @else
                            <div class="form-group">
                                <label>Select Employee <span class="required">*</span></label>
                                <select name="employee" id="employee" class="form-control select2" required="">
                                    <option value="">Select Employee</option>
                                    @foreach($employess as $emp)
                                    <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                            <div class="form-group">
                               <label>Waring Letter No <span class="required"></span></label>
                               <select class="form-control" id="warning_no" name="warning_no" required="" {{(Auth::user()->role != 1)? 'disabled' : ''}}>
                                   <option value="">Select Waring Number</option>
                                   @for($i = 1; $i < 4; $i++)
                                   <option value="{{$i}}">Warning Letter {{$i}}</option>
                                   @endfor
                               </select>
                            </div>
                            @if(Auth::user()->role == 1)
                            <div class="form-group">
                               <label>Status <span class="required"></span></label>
                               <select class="form-control" id="status" name="status" required="">
                                   <option value="1">Active</option>
                                   <option value="2">InActive</option>
                               </select>
                            </div>
                            <div class="form-group">
                                <div id="attach_file"></div>
                                <br>
                                <label>File</label>
                                <input type="file" name="doc" class="form-control">
                            </div>
                            @endif
                        </div>
                        @if(Auth::user()->role == 1)
                        <input type="hidden" name="warning_letter_id" id="warning_letter_id">
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                        </div>
                        @endif
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
@push('js')
<script type="text/javascript">
	function editData(value){
		$('#editModal').modal('show');
		$('#warning_letter_id').val(value.id)
		$('#name').val(value.title)
        $('#description').val(value.description)
        $('#warning_no').val(value.warning_no)
		$('#employee').val(value.emp_id)
        $('#attach_file').empty()
        if(value.doc){
            $('#attach_file').append(`<a href='#'><i class='fa fa-link'>${value.doc_name}</i></a>`)
        }
        $(".select2").select2();
        $('.select2-container').css('width', '100%');
        
	}
</script>
@endpush