<div class="sidebar-left">
  <div class="sidebar">
      <div class="sidebar-content email-app-sidebar d-flex">
          <span class="sidebar-close-icon">
              <i class="feather icon-x"></i>
          </span>
          <div class="email-app-menu">
              <div class="form-group form-group-compose text-center compose-btn">
                  <button type="button" class="btn btn-primary btn-block my-2 waves-effect waves-light" data-toggle="modal" data-target="#composeForm">
                      <i class="feather icon-plus"></i> Add Task
                  </button>
              </div>
              <div class="sidebar-menu-list ps">
                  <div class="list-group list-group-messages font-medium-1">
                      <a href="#" class="list-group-item list-group-item-action border-0 pt-0"><i class="font-medium-5 feather icon-mail mr-50"></i> Inbox <span class="badge badge-primary badge-pill float-right">3</span></a>
                      <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 fa fa-paper-plane-o mr-50"></i> Sent</a>
                      <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 feather icon-edit-2 mr-50"></i> Draft <span class="badge badge-warning badge-pill float-right">4</span> </a>
                      <a href="#" class="list-group-item list-group-item-action border-0 active"><i class="font-medium-5 feather icon-star mr-50"></i>Starred</a>
                      <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 feather icon-info mr-50"></i>Spam <span class="badge badge-danger badge-pill float-right">3</span> </a>
                      <a href="#" class="list-group-item list-group-item-action border-0"><i class="font-medium-5 feather icon-trash mr-50"></i>Trash</a>
                  </div>
                  <hr>
              </div>
          </div>
      </div>

      <!-- Modal -->
      <div class="modal fade text-left" id="composeForm" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel17">Add {{$title}}</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="POST" action="{{ url('tasks') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Title <span class="required">*</span></label>
                            <input type="text" name="name" class="form-control" placeholder="Enter Task Title" required="">
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" name="description" placeholder="Enter Task Description"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Project <span class="required">*</span></label>
                            <select name="project" class="form-control select2" required="">
                                <option value="">Select Project</option>
                                @foreach($projects as $project)
                                <option value="{{ $project->id }}">{{ $project->name }}</option>
                                @endforeach 
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Select Employee <span class="required">*</span></label>
                            <select name="employee[]" class="form-control select2" required="" multiple="multiple">
                                @foreach($employee as $emp)
                                <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <!-- <div class="form-group">
                            <label>Task Type <span class="required">*</span></label>
                            <select name="type" class="form-control" required="">
                                <option value="">Select Type</option>
                                <option value="1">General</option>
                                <option value="2">Reminder</option>
                            </select>
                        </div> -->
                        <div class="form-group row">
                            <div class="col">
                                <label>Start Date</label>
                                <input type="date" name="start_date" class="form-control" value="">
                            </div>
                            <div class="col">
                                <label>End Date</label>
                                <input type="date" name="end_date" class="form-control" value="">
                            </div>
                        </div>
                        <div class="form-group">
                            <label>File</label>
                            <input type="file" name="doc[]" class="form-control" multiple="">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

  </div>
</div>