@extends('layouts.master')
@push('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">

<?php $unread_tasks = !empty(Auth::user()->employee->unread_tasks) ? Auth::user()->employee->unread_tasks : 0; ?>
<style type="text/css">
    .col-6{
        margin-top: 10px;
    }
    .required{
        font-weight: 800;
        color: red;
    }
    label{
        font-weight: 600;
    }
    .form-inline a{
        padding: 10px;
    }
    .unread_feedback{
        background: rgba(34, 41, 47, 0.05) !important;
    }
    .col-md-2{
        margin-top: 5px;
    }
</style>
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-body">
        <div class="card">
            <div class="card-body">
                <form method="GET">
                    <div class="row">
                        <div class="col-md-2">
                            <input type="text" class="form-control" name="daterange" id="daterange" placeholder="Enter Date range" value="{{ ($request->daterange)?: '' }}" />
                        </div>
                        <div class="col-md-2">
                            <select name="project" class="form-control select2">
                                <option value="">Select Project</option>
                                @foreach($projects as $project)
                                <option value="{{ $project->id }}" {{ ($request->project == $project->id)? 'selected' : '' }}>{{ $project->name }}</option>
                                @endforeach 
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="employee" class="form-control select2">
                                <option value="">Select Employee</option>
                                @foreach($employee as $emp)
                                <option value="{{ $emp->id }}" {{ ($request->employee == $emp->id)? 'selected' : '' }}>{{ $emp->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="asign_by" class="form-control select2">
                                <option value="">Select Asign By</option>
                                @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ ($request->asign_by == $user->id)? 'selected' : '' }}>{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="status" class="form-control">
                                <option value="">Select Status</option>
                                <option value="1" {{ ($request->status == 1)? 'selected' : '' }}>Pending</option>
                                <option value="2" {{ ($request->status == 2)? 'selected' : '' }}>Processing</option>
                                <option value="3" {{ ($request->status == 3)? 'selected' : '' }}>Awaiting For Approval</option>
                                <option value="4" {{ ($request->status == 4)? 'selected' : '' }}>Done</option>
                                <option value="5" {{ ($request->status == 5)? 'selected' : '' }}>Over Due</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select name="read_status" class="form-control">
                                <option value="">Select Read/Unread</option>
                                <option value="1" {{ ($request->read_status == 1)? 'selected' : '' }}>Read</option>
                                <option value="2" {{ ($request->read_status == 2)? 'selected' : '' }}>UnRead</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <div class="form-inline">
                                <button class="btn btn-success"><i class="fa fa-search"></i></button>
                                <a href="{{ url('tasks') }}" class="btn btn-danger" style="margin-left: 5px; color: #fff;"><i class="fa fa-refresh"></i></a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Table Hover Animation start -->
        <div class="row" id="table-hover-animation" style="margin-top: 10px;">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $title }} List  <span id="unread_tasks_total" style="color: red; font-weight: 600;"></span></h4>
                        <button class="btn btn-info" data-toggle="modal" data-target="#large"><i class="fa fa-plus"></i> Add {{ $title }}</button>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover-animation">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Title</th>
                                            <th>Doc</th>
                                            <th width="10%">Date</th>
                                            <th>Left Days</th>
                                            <th>Project</th>
                                            <th width="15%">Collaborator</th>
                                            <th>Assign By</th>
                                            <th>Status</th>    
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php 
                                            $can_edit = 0; 
                                        @endphp
                                        @foreach($tasks as $key => $list)
                                        
                                        @if(Auth::user()->role == 1 || $list->created_by == Auth::user()->id)
                                            @php $can_edit = 1; @endphp
                                        @endif
                                        @php
                                            $today_date = \Carbon\Carbon::createFromFormat('Y-m-d', date('Y-m-d'));
                                            $start_date = ($list->start_date)? \Carbon\Carbon::createFromFormat('Y-m-d', $list->start_date) : date('Y-m-d');
                                            $end_date = ($list->end_date)? \Carbon\Carbon::createFromFormat('Y-m-d', $list->end_date) : date('Y-m-d');
                                            $diff_in_days = (($today_date->diffInDays($end_date) + 1) > 0)? ($today_date->diffInDays($end_date) + 1) : 1 ;
                                            $task_day = (($start_date->diffInDays($end_date) + 1) > 0)? ($start_date->diffInDays($end_date) + 1) : 1 ;
                                        @endphp
                                        <tr>
                                            
                                            <td>{{ ++$key }}</td>
                                            <td>{{ $list->title }} <span id="task-feedback-{{ $list->id }}" style="color: green; font-weight: 600;">{{ count($list->unread_feedback)? '('.count($list->unread_feedback)  .')' : '' }}</span></td>
                                            <td> 
                                                @if($list->email_files=="Yes")
                                                    <span>You have attachmnet for this task. Please check your email</span>
                                                @endif 
                                            </td>
                                            <td>
                                                {{ date('d M y', strtotime($list->start_date)) .' - '.date('d M y', strtotime($list->end_date)) }}
                                            </td>
                                            <td>
                                                @if($list->status == 4)
                                                <button class="btn btn-success btn-sm">Task Complete (<small>{{ date('d M y', strtotime($list->done_date)) }}</small>)</button>
                                                <br>
                                                
                                                @elseif(date('Y-m-d') > date('Y-m-d', strtotime($list->end_date)))
                                                <button class="btn btn-danger btn-sm">Over Due</button>
                                                @else
                                                <button class="btn btn-primary btn-sm">{{$diff_in_days .' Days'}}</button>
                                                @endif
                                            </td>
                                            <td>{{ $list->project->name }}</td>
                                            <td>
                                                @foreach($list->employee_task as $emp_task)
                                                <button type="button" class="btn btn-dark mr-1 mb-1 waves-effect waves-light btn-sm" title="{{ $emp_task->employee->department->name }}">{{ $emp_task->employee->name }}</button>
                                                @endforeach
                                            </td>
                                            <td>{{ $list->user->name }}</td>

                                            <td>
                                                @if($list->status == 1)
                                                <button class="btn btn-light btn-sm">Pending</button>
                                                @elseif($list->status == 2)
                                                <button class="btn btn-warning btn-sm">Processing</button>
                                                @elseif($list->status == 4)
                                                <button class="btn btn-success btn-sm">Done</button>
                                                @elseif($list->status == 3)
                                                <button class="btn btn-info btn-sm">Awaiting For Approval</button>
                                                @else
                                                --
                                                @endif
                                            </td>
                                           
                                            <td>
                                                <button onclick="editData( {{json_encode($list)}}, {{$can_edit}} )" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i> </button>    

                                                @if(Auth::user()->role == 1 || $list->created_by == Auth::user()->id)

                                                 <button type="button" class="btn btn-sm bg-gradient-danger" onclick="return deleteCertification(<?php echo $list->id; ?>)" title="delete"><i class="fa fa-trash-o"></i></button>
                                                <form id="delete-form-{{$list->id}}" action="{{ url('tasks',$list->id) }}" method="POST" style="display: none;">
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                                @else
                                                ---
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="paginate" style="float: right;">
                                {{ $tasks->appends(Request::except('page'))->links() }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table head options end -->

        <!-- Modal -->
        <div class="modal fade text-left" id="large" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel17">Add {{$title}}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('tasks') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Title <span class="required">*</span></label>
                                <input type="text" name="name" class="form-control" placeholder="Enter Task Title" required="">
                            </div>
                            <div class="form-group">
                                <label>Description</label>
                                <textarea class="form-control summernote" name="description"></textarea>
                            </div>
                            <div class="form-group">
                                <label>Project <span class="required">*</span></label>
                                <select name="project" class="form-control select2" required="">
                                    <option value="">Select Project</option>
                                    @foreach($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->name }}</option>
                                    @endforeach 
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Select Employee <span class="required">*</span></label>
                                <select name="employee[]" class="form-control select2" required="" multiple="multiple">
                                    @foreach($employee as $emp)
                                    <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <!-- <div class="form-group">
                                <label>Task Type <span class="required">*</span></label>
                                <select name="type" class="form-control" required="">
                                    <option value="">Select Type</option>
                                    <option value="1">General</option>
                                    <option value="2">Reminder</option>
                                </select>
                            </div> -->
                            <div class="form-group row">
                                <div class="col">
                                    <label>Start Date</label>
                                    <input type="date" name="start_date" class="form-control" value="" required="">
                                </div>
                                <div class="col">
                                    <label>End Date</label>
                                    <input type="date" name="end_date" class="form-control" value="" required="">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>File</label><br/>
                                Please email your file if you have any attachment.
                                <input type="checkbox" name="email_files" class="">
                                <!--<input type="file" name="doc[]" class="form-control" multiple="">--> 
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Edit Modal -->
        <div class="modal fade text-left" id="editModal" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel17">Update {{$title}}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('tasks-update') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Title <span class="required">*</span></label>
                                        <input type="text" id="title" name="name" class="form-control" placeholder="Enter Task Title" required="">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Project <span class="required">*</span></label>
                                        <select name="project" id="project" class="form-control" required="">
                                            <option value="">Select Project</option>
                                            @foreach($projects as $project)
                                            <option value="{{ $project->id }}">{{ $project->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Select Employee <span class="required">*</span></label>
                                        <select name="employee[]" id="employee" class="form-control select2" required="" multiple="multiple">
                                            @foreach($employee as $emp)
                                            <option value="{{ $emp->id }}">{{ $emp->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Task Status <span class="required">*</span></label>
                                        <select name="status" id="status" class="form-control" required="">
                                            <option value="">Select Status</option>
                                            <option value="1">Pending</option>
                                            <option value="2">Processing</option>
                                            <option value="3">Awaiting for Approval</option>
                                            <option id="done_option" value="4">Done</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Description</label>
                                @if($can_edit)
                                    <textarea class="form-control summernote" name="description" id="description_text" contenteditable="false"></textarea>
                                @else
                                <span id="description" ></span>
                                @endif
                            </div>
                            
                            <div class="form-group row">
                                <div class="col">
                                    <label>Start Date</label>
                                    <input type="date" id="start_date" name="start_date" class="form-control" value="">
                                </div>
                                <div class="col">
                                    <label>End Date</label>
                                    <input type="date" id="end_date" name="end_date" class="form-control" value="">
                                </div>
                            </div>
                            <!-- col -->
                            <hr>
                            <h4><i class="fa fa-activity"></i>Activity</h4>
                            <hr>

                            <div class="form-group">
                                <label>Add Your Feedback</label>
                                <textarea class="form-control summernote" name="feed_back"></textarea>
                            </div>
                            <hr>
                            <div class="form-group">
                                <label>Attachment</label>
                                Please email your file if you have any attachment.
                                <input type="checkbox" name="email_files" id="email_files" class="">
                                <!--<input type="file" class="form-control" name="attach[]" multiple="" /> -->
                            </div>
                            <hr>
                            <div id="feed_back_history">
                                
                            </div>
                        </div>
                        <input type="hidden" name="task_id" id="task_id">
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
@push('js')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#done_option').hide()
        $('#attachment').hide();
        $('.summernote').summernote();
        $('#daterange').daterangepicker({
            autoUpdateInput: false,
            locale: {
                cancelLabel: 'Clear'
            }
        });
    });
    $('#daterange').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
    });

    $('#daterange').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
 
    function editData(value, can_edit){
        $("#employee").val(null).trigger('change');
        $('#loading').show();        
        $('#feed_back_history').empty()
        $('#attachment_data').empty()
        $('#editModal').modal('show');
        $('#task_id').val(value.id)
        $('#title').val(value.title)
        

        $('#project').val(value.project_id)
        $('#start_date').val(value.start_date)
        $('#end_date').val(value.end_date)
        $('#status').val(value.status)
        if(value.email_files=='Yes'){
            $('#email_files').attr('checked', true);
        }        
        
        $('#status').attr('disabled', false)
        if(can_edit){
            $('#title').attr('disabled', false)
            $("#description_text").summernote("reset");
            if(value.description){
                $('#description_text').summernote('pasteHTML', value.description);
            }
            $('#email_files').attr('disabled', false)
            $('#project').attr('disabled', false)
            $('#start_date').attr('disabled', false)
            $('#end_date').attr('disabled', false)
        }else{
            $('#title').attr('disabled', true)
            $('#employee').attr('disabled', true)  
            $('#description').html(value.description);    
            $('#email_files').attr('disabled', true)
            $('#project').attr('disabled', true)
            $('#start_date').attr('disabled', true)
            $('#end_date').attr('disabled', true)
        }
        
        var emp_id = [];
        if(value.employee_task.length){
           $.each(value.employee_task, function(i, item) {
                emp_id.push(item.employee_id)
            });

            $.each(emp_id, function(i,e){
                $("#employee option[value='" + e + "']").prop("selected", true);
            });
        }

        $('#task-feedback-'+value.id).remove()
        $('#table-tr-'+value.id).removeClass('unread_feedback')

        if(value.task_docs.length){
            var task_html = '';
           $.each(value.task_docs, function(i, taskItem) {
                var task_attach_name = (taskItem.doc_name ? taskItem.doc_name : '');
                    task_html += `
                        <div id="task_doc_id_${taskItem.id}">
                            <button type="button" onclick="taskAttachmentRemove(${taskItem.id})" class="btn btn-danger btn-sm"><i class="fa fa-trash-o"></i></button>
                            <a href="/storage/task/${taskItem.doc}" download>${task_attach_name}</a>
                        </div>
                    `;
            });
            $('#attachment').show();
            $('#attachment_data').empty();
           
           $('#attachment_data').append(task_html);
        }else{
            $('#attachment').hide();
        }

        $.ajax({
            url: "/get-feedback-data-by-task-id",
            type:"GET",
            data:{
              task_id : value.id,
            },
            success:function(response){
                if(response.status){
                    var html = '';
                    $.each(response.data, function(i, item) {
                        html += `
                            <div class="d-flex justify-content-start align-items-center mb-2">
                                <div class="avatar mr-50">
                                  <img src="/storage/uploads/${item.user.photo}" alt="${item.user.name}" height="30" width="30">
                                </div>
                                <div class="user-page-info">
                                  <h6 class="mb-0">${item.user.name}</h6>
                                  <span style="width: 60%;" class="font-small-2">${item.description}</span>
                                </div>
                                <div class="ml-auto cursor-pointer">
                                    <small style="float:right;">${item.created_at}</small>
                                    <br>`;
                                if(item.attachment.length){
                                    $.each(item.attachment, function(i, att_item){
                                        var attach_name = (att_item.doc_name ? att_item.doc_name : '');
                                        html += `<a style="    margin-left: 3px;margin-top: 3px;" class="btn btn-outline-info waves-effect btn-sm" href="/storage/attach/${att_item.doc}" download>${i+1}. ${attach_name}</a>`;
                                    });
                                }
                            html +='</div></div>';
                           
                   
                    });
                    $('#feed_back_history').empty()
                    $('#feed_back_history').append(html)
                }
            
            },
        });
        var role_id = {{ Auth::user()->role }};
        var user_id = {{ Auth::user()->id }};
        if(role_id == 1 || user_id == value.created_by){
            $('#done_option').show()
        }else{            
            $('#done_option').hide()
        }
        $('#loading').hide();
        $(".select2").select2();
        $('.select2-container').css('width', '100%');
    
    }

    function editData__(value, can_edit){
        $("#employee").val(null).trigger('change');
        $('#loading').show();
        $("#description").summernote("reset");
        $('#feed_back_history').empty()
        $('#attachment_data').empty()
        $('#editModal').modal('show');
        $('#task_id').val(value.id)
        $('#title').val(value.title)
        if(value.description){
            $('#description').summernote('pasteHTML', value.description);
        }

        $('#project').val(value.project_id)
        $('#start_date').val(value.start_date)
        $('#end_date').val(value.end_date)
        $('#status').val(value.status)
        if(value.email_files=='Yes'){
            $('#email_files').attr('checked', true);
        }        
        
        $('#status').attr('disabled', false)
        if(can_edit){
            $('#doc_file').attr('disabled', false)
            $('#project').attr('disabled', false)
            $('#start_date').attr('disabled', false)
            $('#end_date').attr('disabled', false)
        }else{
            $('#doc_file').attr('disabled', true)
            $('#project').attr('disabled', true)
            $('#start_date').attr('disabled', true)
            $('#end_date').attr('disabled', true)
        }
        
        var emp_id = [];
        if(value.employee_task.length){
           $.each(value.employee_task, function(i, item) {
                emp_id.push(item.employee_id)
            });

            $.each(emp_id, function(i,e){
                $("#employee option[value='" + e + "']").prop("selected", true);
            });
        }

        $('#task-feedback-'+value.id).remove()
        $('#table-tr-'+value.id).removeClass('unread_feedback')

        if(value.task_docs.length){
            var task_html = '';
           $.each(value.task_docs, function(i, taskItem) {
                var task_attach_name = (taskItem.doc_name ? taskItem.doc_name : '');
                    task_html += `
                        <div id="task_doc_id_${taskItem.id}">
                            <button type="button" onclick="taskAttachmentRemove(${taskItem.id})" class="btn btn-danger btn-sm"><i class="fa fa-trash-o"></i></button>
                            <a href="/storage/task/${taskItem.doc}" download>${task_attach_name}</a>
                        </div>
                    `;
            });
            $('#attachment').show();
            $('#attachment_data').empty();
           
           $('#attachment_data').append(task_html);
        }else{
            $('#attachment').hide();
        }

        $.ajax({
            url: "/get-feedback-data-by-task-id",
            type:"GET",
            data:{
              task_id : value.id,
            },
            success:function(response){
                if(response.status){
                    var html = '';
                    $.each(response.data, function(i, item) {
                        html += `
                            <div class="d-flex justify-content-start align-items-center mb-2">
                                <div class="avatar mr-50">
                                  <img src="/storage/uploads/${item.user.photo}" alt="${item.user.name}" height="30" width="30">
                                </div>
                                <div class="user-page-info">
                                  <h6 class="mb-0">${item.user.name}</h6>
                                  <span style="width: 60%;" class="font-small-2">${item.description}</span>
                                </div>
                                <div class="ml-auto cursor-pointer">
                                    <small style="float:right;">${item.created_at}</small>
                                    <br>`;
                                if(item.attachment.length){
                                    $.each(item.attachment, function(i, att_item){
                                        var attach_name = (att_item.doc_name ? att_item.doc_name : '');
                                        html += `<a style="    margin-left: 3px;margin-top: 3px;" class="btn btn-outline-info waves-effect btn-sm" href="/storage/attach/${att_item.doc}" download>${i+1}. ${attach_name}</a>`;
                                    });
                                }
                            html +='</div></div>';
                           
                   
                    });
                    $('#feed_back_history').empty()
                    $('#feed_back_history').append(html)
                }
            
            },
        });
        var role_id = {{ Auth::user()->role }};
        var user_id = {{ Auth::user()->id }};
        if(role_id == 1 || user_id == value.created_by){
            $('#done_option').show()
        }else{            
            $('#done_option').hide()
        }
        $('#loading').hide();
        $(".select2").select2();
        $('.select2-container').css('width', '100%');
       
    }

    function taskAttachmentRemove(id){
        if (confirm("Are you Sure, you want to delete it ?")) {
            if(id){
                $.ajax({
                    url: "/tasks-docs-destroy",
                    type:"GET",
                    data:{
                      task_doc_id : id,
                    },
                    success:function(response){
                        if(response.status){
                            $('#task_doc_id_'+id).remove()
                            swal("Good job!", response.message, "success");
                        }else{
                            swal("Error!", response.message, "error");
                        }
                    },
                });
            }else {
                swal("Error!", 'Something went wrong, please try again', "error");
            }
        } 
    }
</script>


@endpush