<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{$title}}</title>
    <style type="text/css">
        .page-break {
            page-break-after: always;
        }
        .header{
            text-align: center;
            align-items: center;
        }
        h1{
            padding: 0;
            margin: 0;
        }
        table{
            width: 100%;
            border-collapse: collapse;
        }
        table td, th {
            border: 1px solid black;
            text-align: center;
        }
        .text-right{
            text-align: right !important;
        }
        .text-left{
            text-align: left !important;
        }
        footer {
            position: fixed;
            bottom: -10px;
            left: 0px;
            right: 0px;
            height: 1px;
        }
        .footer-inner {
            position: absolute;
            bottom: 40px;
            width: 100%;
        }
        .text-bold{
            font-weight: 600;
            color: green;
        }
    </style>
</head>
<body>
    <div class="main_container">
        <div class="header">
            <img src="{{asset('backend/app-assets/images/logo/worldwise_shaglobal.jpeg')}}" width="100">
            {{-- <div id="address">
                Sayra Monzil, 59 Dishary, Hawapara, Sylhet-3100
            </div> --}}
            @if(isset($date_show))
            <span>{{ $date_show }}</span>
            @endif


        </div>
        <h2 style="margin-bottom: 5px !important; margin-bottom: 5px !important; padding-bottom: 5px !important" align="center">{{$title}}: </h2>
        <h2 style="font-size: 15px;" align="center">Name:  {{ $user->name }} </h2>
        <div class="page_break">
            <div class="test_details" style="margin-top: 10px;">
                <table>
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>Sign In</th>
                        <th>Sign Out</th>
                        <th>Break Time</th>
                        <th>Total Hour</th>
                    </tr>
                    @foreach($sign_in_out_reports as $key => $list)
                    @if($list->break_time)
                        @php
                            $date_arr = explode(":", $list->break_time);
                            $hours = (isset($date_arr[0]) && $date_arr[0] > 0)? $date_arr[0]  : 0 ;
                            $minutes = (isset($date_arr[1]) && $date_arr[1] > 0)? $date_arr[1] : 0 ;
                        @endphp
                    @endif
                    <tr>
                        <td>{{++$key}}</td>
                        <td>{{ $list->user->name }}</td>
                        <td>{{ ($list->date)? \Carbon\Carbon::parse($list->date)->format('d M y') : '-- --' }}</td>
                        <td>{{ ($list->sign_in)? \Carbon\Carbon::parse($list->sign_in)->format('h:i a') : '-- -- -- --' }}</td>
                        <td>{{ ($list->sign_out)? \Carbon\Carbon::parse($list->sign_out)->format('h:i a') : '-- -- -- --' }}</td>
                        <td>
                            @if($list->break_time)
                            {{ $hours }} :
                            {{ $minutes }} Hours
                            @endif
                        </td>
                        <td>
                            @if($list->sign_in && $list->sign_out)
                                @if($list->break_time)
                                    @php $start = \Carbon\Carbon::parse($list->sign_in)->addMinutes($minutes)->addHours($hours) @endphp
                                @else
                                    @php $start = \Carbon\Carbon::parse($list->sign_in); @endphp
                                @endif
                                @php
                                    $end = \Carbon\Carbon::parse($list->sign_out);
                                    $totalDuration =  $start->diff($end)->format('%H');
                                    $minute =  $start->diff($end)->format('%i');
                                @endphp
                                {{ ($totalDuration > 0)? $totalDuration.' Hours' : '' }}
                                {{ ($minute > 0)? $minute.' Minutes' : '' }}
                            @endif
                        </td>
                    </tr>
                    
                    @endforeach
                </table>
            </div>
        </div>

        <!--Footer-->
        <footer id="footer">
            <div class="footer-inner">
                <hr style="width: 200px;margin-left: 0;background: black;" size="1"/>
                <span style="margin-left: 50px;">Manager Signature</span>
            </div>
            <div align="right">

            <small style="text-align: right; font-size: 10px; font-family: monospace;">print date: {{\Carbon\Carbon::now()}}</small>
            </div>
        </footer>
    </div>
</body>
</html>