<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
	<title>{{$title}}</title>
	<style type="text/css">
		.page-break {
		    page-break-after: always;
		}
		.header{
			text-align: center;
			align-items: center;
		}
		h1{
			padding: 0;
			margin: 0;
		}
		table{
			width: 100%;
			border-collapse: collapse;
		}
		table td, th {
            border: 1px solid black;
            text-align: center;
        }
        .text-right{
        	text-align: right !important;
        }
        .text-left{
        	text-align: left !important;
        }
        footer {
            position: fixed;
            bottom: -10px;
            left: 0px;
            right: 0px;
            height: 1px;
        }
        .footer-inner {
            position: absolute;
            bottom: 40px;
            width: 100%;
        }
        .text-bold{
            font-weight: 600;
            color: green;
        }
	</style>
</head>
<body>
	<div class="main_container">
		<div class="header">
			<img src="{{asset('backend/app-assets/images/logo/worldwise_shaglobal.jpeg')}}" width="100">
            {{-- <div id="address">
                Sayra Monzil, 59 Dishary, Hawapara, Sylhet-3100
            </div> --}}
            @if(isset($date_show))
            <span>{{ $date_show }}</span>
            @endif
		</div>
		<h2 style="margin-bottom: 5px !important; margin-bottom: 5px !important; padding-bottom: 5px !important" align="center">{{$title}}: </h2>
		<div class="page_break">
			<div class="test_details" style="margin-top: 10px;">
				<table>
                    <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Complete Date</th>
                        <th>Project</th>
                        <th>Collaborator</th>
                        <th>Assign By</th>
                    </tr>
                    @foreach($tasks as $key => $list)
                    @php
                        $today_date = \Carbon\Carbon::createFromFormat('Y-m-d', date('Y-m-d'));
                        $start_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->end_date);
                        $end_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->end_date);
                        $diff_in_days = (($today_date->diffInDays($end_date) + 1) > 0)? ($today_date->diffInDays($end_date) + 1) : 1 ;
                        $task_day = (($start_date->diffInDays($end_date) + 1) > 0)? ($start_date->diffInDays($end_date) + 1) : 1 ;
                    @endphp

                    <tr>
                        <td>{{ ++$key }}</td>
                        <td>{{ $list->title }} <span id="task-feedback-{{ $list->id }}" style="color: green; font-weight: 600;">{{ count($list->unread_feedback)? '('.count($list->unread_feedback)  .')' : '' }}</span></td>
                        <td>{{ date('d M y', strtotime($list->start_date)) }}</td>
                        <td>{{ date('d M y', strtotime($list->end_date)) }}</td>
                        <td>
                            {{ date('d M y', strtotime($list->done_date)) }}                                            
                        </td>
                        <td>{{ $list->project->name }}</td>
                        <td>
                            @foreach($list->employee_task as $emp_task)
                                <p>{{ $emp_task->employee->name }},</p>
                            @endforeach
                        </td>
                        <td>{{ $list->user->name }}</td>
                    </tr>
                    
                    @endforeach
                </table>
			</div>
		</div>

		<!--Footer-->
        <footer id="footer">
            <div class="footer-inner">
                <hr style="width: 200px;margin-left: 0;background: black;" size="1"/>
                <span style="margin-left: 50px;">Manager Signature</span>
            </div>
            <div align="right">

            <small style="text-align: right; font-size: 10px; font-family: monospace;">print date: {{\Carbon\Carbon::now()}}</small>
            </div>
        </footer>
	</div>
</body>
</html>