@extends('layouts.master')
@push('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<style type="text/css">
    label{
        font-weight: 600;
    }
</style>
@endpush
@php $total = ''; @endphp;
@section('content')
<div class="content-wrapper">
    <div class="content-header row">
    </div>
    <div class="content-body">
        <!-- Dashboard Ecommerce Starts -->
        <section id="dashboard-ecommerce">
            <form method="GET" id="filterForm">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-2">
                                <input type="text" class="form-control" name="daterange" id="daterange" placeholder="Enter Date range" value="{{ ($request->daterange)?: '' }}" />
                            </div>
                            <div class="col-md-2">
                                <select name="project" class="form-control select2">
                                    <option value="">Select Project</option>
                                    @foreach($projects as $project)
                                    <option value="{{ $project->id }}" {{ ($request->project == $project->id)? 'selected' : '' }}>{{ $project->name }}</option>
                                    @endforeach 
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="employee" class="form-control select2">
                                    <option value="">Select Employee</option>
                                    @foreach($employees as $emp)
                                    <option value="{{ $emp->id }}" {{ ($request->employee == $emp->id)? 'selected' : '' }}>{{ $emp->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="asign_by" class="form-control select2">
                                    <option value="">Select Asign By</option>
                                    @foreach($users as $user)
                                    <option value="{{ $user->id }}" {{ ($request->asign_by == $user->id)? 'selected' : '' }}>{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                                                
                            
                            <input type="hidden" name="sub_type" id="sub_type" value="">
                            <div class="col-md-3">
                                <div class="form-inline">
                                    <button onclick="formSubmit(1)" type="button" class="btn btn-success"><i class="fa fa-search"></i></button>
                                    <button type="button" onclick="formSubmit(2)" class="btn btn-primary" style="margin-left: 5px;"><i class="fa fa-download"></i></button>
                                    <a href="{{ url('over-due-tasks') }}" class="btn btn-danger" style="margin-left: 5px; color: #fff;"><i class="fa fa-refresh"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            <div class="row" style="margin-top: 10px;">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">Task <span style="font-weight: 600;color: green;" id="total_due_task"></span></div>
                        <div class="card-body table-responsive">
                            <table class="table table-bordered table-striped table-hover-animation">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Title</th>
                                        <th>Start Date</th>
                                        <th>End Date</th>
                                        <th>Complete Date</th>
                                        <th width="15%">Collaborator</th>
                                        <th>Project</th>
                                        <th>Assign By</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($tasks as $key => $list)
                                        @if($list->end_date < $list->done_date)
                                        @php $total++; @endphp
                                            @php
                                                $today_date = \Carbon\Carbon::createFromFormat('Y-m-d', date('Y-m-d'));
                                                $start_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->end_date);
                                                $end_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->end_date);
                                                $diff_in_days = (($today_date->diffInDays($end_date) + 1) > 0)? ($today_date->diffInDays($end_date) + 1) : 1 ;
                                                $task_day = (($start_date->diffInDays($end_date) + 1) > 0)? ($start_date->diffInDays($end_date) + 1) : 1 ;
                                            @endphp

                                            <tr>
                                                <td>{{ ++$key }}</td>
                                                <td>{{ $list->title }} <span id="task-feedback-{{ $list->id }}" style="color: green; font-weight: 600;">{{ count($list->unread_feedback)? '('.count($list->unread_feedback)  .')' : '' }}</span></td>
                                                <td>
                                                    {{ date('d M y', strtotime($list->start_date)) }}
                                                </td>
                                                <td>{{ date('d M y', strtotime($list->end_date)) }}</td>
                                                <td>
                                                    {{ date('d M y', strtotime($list->done_date)) }}                                            
                                                </td>
                                                <td>
                                                    @foreach($list->employee_task as $emp_task)
                                                        <button type="button" class="btn btn-dark mr-1 mb-1 waves-effect waves-light btn-sm" title="{{ $emp_task->employee->department->name }}">{{ $emp_task->employee->name }}</button>
                                                    @endforeach
                                                </td>
                                                <td>{{ $list->project->name }}</td>
                                                <td>{{ $list->user->name }}</td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                            <input type="hidden" name="total_due_task" id="total_due_task_get" value="{{ $total }}">
                            <div class="paginate" style="float: right; margin-top: 10px;">
                                {!! $tasks->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Dashboard Ecommerce ends -->

    </div>
</div>
@endsection
@push('js')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        var total_due_task_get = $('#total_due_task_get').val();
        if(total_due_task_get){
            $('#total_due_task').html('Total: '+total_due_task_get);
        }else{
            $('#total_due_task').html('');
        }
         
        $('#daterange').daterangepicker({
            autoUpdateInput: false,
            locale: {
                cancelLabel: 'Clear'
            }
        });
    });
    $('#daterange').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
    });

    $('#daterange').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });


    function formSubmit(type){
        if(type == 1){
            $('#sub_type').val('')
            $('#filterForm').attr('target', '')
        }else if(type == 2){
            $('#filterForm').attr('target', '_blank')
            $('#sub_type').val('export')
        }else{
            $('#sub_type').val('')
            $('#filterForm').attr('target', false)
        }
        
        $('#filterForm').submit();
    }

</script>
@endpush
