@extends('layouts.master')
@push('css')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<style type="text/css">
    .col-6{
        margin-top: 10px;
    }
    .required{
        font-weight: 800;
        color: red;
    }
    label{
        font-weight: 600;
    }
    .btn-light{
        background-color: #156b53 !important;
    }

</style>
@endpush
@section('content')

<div class="content-wrapper">

    <div class="content-body">
        <!-- Table Hover Animation start -->
        <div class="row" id="table-hover-animation">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $title }} List</h4>
                        <div class="content-header-right text-md-right col-md-3 col-12 d-md-block d-none">
                            @if(Auth::user()->role == 1)
                            <button class="btn btn-info" data-toggle="modal" data-target="#large"><i class="fa fa-plus"></i> Add {{ $title }}</button>
                            @endif
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover-animation" id="dt-datatable">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Title</th>
                                            <th>Short Description</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(count($notice_boards))
                                    	@foreach($notice_boards as $key => $list)
                                        <tr>
                                            <th>{{ ++$key }}</th>
                                            <td>{{ $list->title }}</td>
                                            <td>{{ $list->short_description }}</td>
                                            <td>
                                                @if($list->status == 1)
                                                <button class="btn btn-success btn-sm">Active</button>
                                                @else
                                                <button class="btn btn-danger btn-sm">Active</button>
                                                @endif
                                            </td>
                                            <td>
                                                <button class="btn btn-primary btn-sm" onclick="editData({{ json_encode($list) }})"><i class="fa fa-edit"></i></button>
                                            	<button type="button" class="btn btn-sm bg-gradient-danger" onclick="return deleteCertification(<?php echo $list->id; ?>)" title="delete"><i class="fa fa-trash-o"></i></button>
				                                <form id="delete-form-{{$list->id}}" action="{{ url('notice-board',$list->id) }}" method="POST" style="display: none;">
				                                    @csrf
				                                    @method('DELETE')
				                                </form>
                                            </td>
                                        </tr>
                                        @endforeach
                                        @else
                                        <tr align="center">
                                            <td colspan="5">Opsss!,, Data Not Found</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table head options end -->

        <!-- Modal -->
        <div class="modal fade text-left" id="large" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel17">Add {{$title}}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('notice-board') }}" enctype="multipart/form-data">
                    	@csrf
                        <div class="modal-body">
                            <div class="form-group">
                            	<label>Title <span class="required">*</span></label>
                            	<input type="text" name="name" class="form-control" placeholder="Enter Title" required="">
                            </div>
                           <div class="form-group">
                               <label>Short Description <span class="required">*</span></label>
                               <textarea class="form-control" name="short_description" placeholder="Enter Short Description"></textarea>
                           </div>
                           <div class="form-group">
                               <label>Long Description <span class="required">*</span></label>
                               <textarea class="form-control summernote" name="description"></textarea>
                           </div>
                            <div class="form-group">
                               <label>Status <span class="required"></span></label>
                               <select class="form-control" name="status" required="">
                                   <option value="1">Active</option>
                                   <option value="0">InActive</option>
                               </select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Edit Modal -->
        <div class="modal fade text-left" id="editModal" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel17">Update {{$title}}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('notice-board-update') }}" enctype="multipart/form-data">
                    	@csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <label>Title <span class="required">*</span></label>
                                <input type="text" id="title" name="name" class="form-control" placeholder="Enter Title" required="">
                            </div>
                           <div class="form-group">
                               <label>Short Description <span class="required">*</span></label>
                               <textarea class="form-control" id="short_description" name="short_description" placeholder="Enter Short Description"></textarea>
                           </div>
                           <div class="form-group">
                               <label>Long Description <span class="required">*</span></label>
                               <textarea class="form-control summernote" id="description" name="description"></textarea>
                           </div>
                            <div class="form-group">
                               <label>Status <span class="required"></span></label>
                               <select class="form-control" name="status" id="status" required="">
                                   <option value="1">Active</option>
                                   <option value="0">InActive</option>
                               </select>
                            </div>
                            <input type="hidden" name="notice_board_id" id="notice_board_id">
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                        </div>  
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
@push('js')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
        $("#description").summernote("reset");
        $('.summernote').summernote({
            height: 300,
        });
    });
</script>
<script type="text/javascript">
	function editData(value){
		$('#editModal').modal('show');
		$('#notice_board_id').val(value.id)
        $('#title').val(value.title)
        $('#short_description').val(value.short_description)
        $("#description").summernote("reset");
        if(value.description){
            $('#description').summernote('pasteHTML', value.description);
        }
        $('#status').val(value.status)
	}
</script>
@endpush