@extends('layouts.master')
@section('content')
@push('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<style type="text/css">
    label{
        font-weight: 600;
    }
    .col-6{
        margin-top: 10px;
    }
    .required{
        font-weight: 800;
        color: red;
    }
    label{
        font-weight: 600;
    }
    .btn-light{
        background-color: #156b53 !important;
    }
</style>
@endpush


<div class="content-wrapper">

    <div class="content-body">
        <div class="card">
            <div class="card-body">
                <form method="GET">
                    <div class="row">
                        <div class="col-md-2">
                            <input type="text" class="form-control" name="daterange" id="daterange" placeholder="Enter Date range" value="{{ ($request->daterange)?: '' }}" />
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <select name="employee" class="form-control select2">
                                    <option value="">Select Employee</option>
                                    @foreach($employees as $emp)
                                    <option value="{{ $emp->id }}" {{ ($request->employee == $emp->id)? 'selected' : '' }}>{{ $emp->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                       
                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control" name="dp_status">
                                    <option value="">Select DH Status</option>
                                    <option value="1" {{ ($request->dp_status == 1)? 'selected' : '' }}>Pending</option>
                                    <option value="2" {{ ($request->dp_status == 2)? 'selected' : '' }}>Approved</option>
                                    <option value="3" {{ ($request->dp_status == 3)? 'selected' : '' }}>Declined</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <select class="form-control" name="hr_status">
                                    <option value="">Select HR Status</option>
                                    <option value="1" {{ ($request->hr_status == 1)? 'selected' : '' }}>Pending</option>
                                    <option value="2" {{ ($request->hr_status == 2)? 'selected' : '' }}>Approved</option>
                                    <option value="3" {{ ($request->hr_status == 3)? 'selected' : '' }}>Declined</option>
                                </select>
                            </div>
                        </div>


                        <div class="col-md-2">
                            <div class="form-inline">
                                <button type="submit" class="btn btn-success"><i class="fa fa-search"></i></button>
                                <a href="{{ url('leave-application-norification') }}"><button type="button" style="margin-left: 5px;" class="btn btn-warning"><i class="fa fa-refresh"></i></button></a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- Table Hover Animation start -->
        <div class="row" id="table-hover-animation">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $title }} List</h4>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover-animation">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            @if(Auth::user()->role != 2)
                                            <th>Name</th>
                                            @endif
                                            <th>Type</th>
                                            <th>Application Date</th>
                                            <th>Start Date</th>
                                            <th>End Date</th>
                                            <th>Days</th>
                                            <th>Reason</th>
                                            <th>DP Status</th>
                                            <th>DP Updated</th>
                                            <th>HR Status</th>
                                            <th>HR Updated</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    	@foreach($leave_applications as $key => $list)
                                        @php
                                            $start_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->start_date);
                                            $end_date = \Carbon\Carbon::createFromFormat('Y-m-d', $list->end_date);
                                            $diff_in_days = (($start_date->diffInDays($end_date) + 1) > 0)? ($start_date->diffInDays($end_date) + 1) : 1 ;
                                        @endphp
                                        <tr>
                                            <th>{{ ++$key }}</th>
                                            @if(Auth::user()->role == 1)
                                                <td>{{ $list->employee->name }}</td>
                                            @endif
                                            <td>
                                                @if($list->type == 1)
                                                Medical Leave
                                                @elseif($list->type == 2)
                                                Personal Leave
                                                @elseif($list->type == 3)
                                                Holiday Leave
                                                @elseif($list->type == 4)
                                                Emergency Leave
                                                @else
                                                ---
                                                @endif
                                            </td>

                                            <td>{{ date('d M y', strtotime($list->application_date))}}</td>
                                            <td>{{ date('d M y', strtotime($list->start_date))}}</td>
                                            <td>{{ date('d M y', strtotime($list->end_date))}}</td>
                                            <td>{{ $diff_in_days }} Days</td>
                                            <td>{{ $list->reason}}</td>
                                            <td>
                                                @if($list->dp_status == 1)
                                                <button class="btn btn-warning btn-sm">Pending</button>
                                                @elseif($list->dp_status == 2)
                                                <button class="btn btn-success btn-sm">Approved</button>
                                                @elseif($list->dp_status == 3)
                                                <button class="btn btn-success btn-sm">Declined</button>
                                                @else
                                                ---
                                                @endif
                                            </td>
                                            <td>
                                                @if($list->dp_approved_by)
                                                $list->dp_head->name
                                                <small>{{ date('d M -y', strtotime($list->dp_approved_date)) }}</small>
                                                @else
                                                ---
                                                @endif
                                            </td>
                                            <td>
                                                @if($list->hr_status == 1)
                                                <button class="btn btn-warning btn-sm">Pending</button>
                                                @elseif($list->hr_status == 2)
                                                <button class="btn btn-success btn-sm">Approved</button>
                                                @elseif($list->hr_status == 3)
                                                <button class="btn btn-success btn-sm">Declined</button>
                                                @else
                                                ---
                                                @endif
                                            </td>
                                            <td>
                                                @if($list->hr_approved_by)
                                                $list->hr_user->name
                                                <small>{{ date('d M -y', strtotime($list->hr_approved_date)) }}</small>
                                                @else
                                                ---
                                                @endif
                                            </td>
                                            
                                            <td>
                                                @if($list->dp_status == 1)
                                                <button type="button" onclick="return editData( {{json_encode($list)}} )" class="btn btn-primary btn-sm"><i class="fa fa-edit"></i></button>
                                            	
                                                @endif
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <div class="paginate" style="float: right;">
                                    {!! $leave_applications->links() !!}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table head options end -->

        <!-- Edit Modal -->
        <div class="modal fade text-left" id="editModal" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="myModalLabel17">Update {{$title}}</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('leave-application-update') }}" enctype="multipart/form-data">
                    	@csrf
                        <div class="modal-body">
                            @if(Auth::user()->role == 1 || Auth::user()->role == 3)
                            <div class="form-group">
                                <label>DP Status</label>
                                <select name="dp_status" id="dp_status" class="form-control">
                                    <option value="1">Pending</option>
                                    <option value="2">Approved</option>
                                    <option value="3">Declined</option>
                                </select>
                            </div>
                            @endif
                            @if(Auth::user()->role == 1 || Auth::user()->role == 4)
                            <div class="form-group">
                                <label>HR Status</label>
                                <select name="hr_status" id="hr_status" class="form-control">
                                    <option value="">Select Status</option>
                                    <option value="1">Pending</option>
                                    <option value="2">Approved</option>
                                    <option value="3">Declined</option>
                                </select>
                            </div>
                            @endif
                            
                        </div>
                        <input type="hidden" name="leave_application_id" id="leave_application_id">
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary"><i class="fa fa-save"></i> Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection
@push('js')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript">
	function editData(value){
		$('#editModal').modal('show');
		$('#leave_application_id').val(value.id)
        $('#dp_status').val(value.dp_status)
        $('#hr_status').val(value.hr_status)
	}


    $(document).ready(function() {
        $('#daterange').daterangepicker({
            autoUpdateInput: false,
            locale: {
                cancelLabel: 'Clear'
            }
        });
    });
    $('#daterange').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
    });

    $('#daterange').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });

</script>
@endpush