@extends('layouts.master')
@section('content')
@push('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<!-- Start Developed By: Abu Taher -->

    <script src="{{asset('backend/app-assets/vendors/js/vendors.min.js')}}"></script>
    <link rel="stylesheet" href="{{asset('backend/app-assets/fullcallendar/css/fullcalendar.css')}}" />

    <link rel="stylesheet" href="{{asset('resources/assets/fullcallendar/css/fullcalendar.css')}}" />
    <script src="//cdnjs.cloudflare.com/ajax/libs/moment.js/2.10.6/moment.js"></script>
<!-- End Developed By: Abu Taher -->
<style type="text/css">
    label{
        font-weight: 600;
    }
    .col-6{
        margin-top: 10px;
    }
    .required{
        font-weight: 800;
        color: red;
    }
    label{
        font-weight: 600;
    }
    .btn-light{
        background-color: #156b53 !important;
    }
</style>
@endpush

<div class="content-wrapper">
    <div class="content-body">
        <form method="GET">
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <input type="text" name="name" value="{{ ($request->name)?: '' }}"
                            class="form-control" placeholder="Enter Name">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <input type="email" name="email"
                            value="{{ ($request->email)?: '' }}" class="form-control"
                            placeholder="Enter Email">
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <input type="text" name="phone" value="{{ ($request->phone)?: '' }}"
                            class="form-control" placeholder="Enter Phone">
                    </div>
                </div>
                <div class="col-md-1">
                    <div class="form-group">
                        <select class="form-control" name="type">
                            <option value="">All Type</option>
                            <option value="1"
                                {{ ($request->type == 1)? 'selected' : '' }}>
                                UK</option>
                            <option value="2"
                                {{ ($request->type == 2)? 'selected' : '' }}>
                                BD</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-inline">
                        <button type="submit" class="btn btn-success"><i class="fa fa-search"></i></button>
                        <a href="{{ url('employee') }}"><button type="button"
                                style="margin-left: 5px;" class="btn btn-warning"><i
                                    class="fa fa-refresh"></i></button></a>
                    </div>
                </div>
            </div>
        </form>
        <!-- Table Hover Animation start -->
        <div class="row" id="table-hover-animation">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $title }} List</h4>
                        <!--<button class="btn btn-info btn-sm" style="float: right;" data-toggle="modal"
                            data-target="#large"><i class="fa fa-plus"></i> Add {{ $title }}</button> -->

                    </div>

                    <div class="card-content">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover-animation mb-0">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Employee Type</th>
                                            <th>Name</th>
                                            <th>User Name</th>
                                            <th>Deserved Holiday</th>
                                            <th>Used Holiday</th>
                                            <th>Left Holiday</th>
                                            <th>Callender</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $holiday = 0;
                                            $used_holiday = 0;
                                            $left_holiday = 0;  
                                        @endphp
                                        @foreach($employess as $key => $list)
                                            @if($list->holiday)
                                                @php
                                                    $holiday = $list->holiday->holiday;
                                                    $used_holiday = $list->holiday->used_holiday;
                                                    $left_holiday = $holiday - $used_holiday;  
                                                @endphp                                          
                                            @endif
                                            <tr>
                                                <td>{{ ++$key }}</td>
                                               
                                                <td>
                                                    @if($list->type == 1)
                                                        <button class="btn btn-primary btn-sm">UK Employee</button>
                                                    @elseif($list->type == 2)
                                                        <button class="btn btn-warning btn-sm">BD Employee</button>
                                                    @else
                                                        --
                                                    @endif
                                                </td>
                                                <td>{{ $list->name }}</td>
                                                <td>{{ $list->user->username }}</td>
                                                <td>{{ $holiday }}</td>
                                                <td>{{ $used_holiday }}</td>
                                                <td>{{ $left_holiday }}</td>
                                                <td>
                                                    <button type="button" onclick="return showCallendar({{$list->emp_id}})" class="btn btn-primary waves-effect waves-light btn-sm"> 
                                                    <strong>Calendar</strong> 
                                                    </button>
                                                </td>
                                                <td>
                                                    @if($list->status == 1)
                                                        <button class="btn btn-success btn-sm">Active</button>
                                                    @elseif($list->status == 2)
                                                        <button class="btn btn-danger btn-sm">Proccessing</button>
                                                    @else
                                                        --
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="paginate" style="float: right;">
                                {!! $employess->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Table head options end -->
        <!-- Calendar Modal -->
        <div class="modal fade text-left" id="callendar" role="dialog" aria-labelledby="callendar" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="callendar">Holiday Lists</h4>                        
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="#">
                        <div class="modal-body">
                            <div id='calendar'></div>
                        </div>
                        <input type="hidden" name="emp_id" id="emp_id">
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
   <script type="text/javascript">
       function showCallendar(emp_id){ 
       
        $('#calendar').fullCalendar('destroy');
        $('#callendar').modal('show');  
        
       /* $.ajax({
            url: '/employee-calendar',
            type: 'POST',
            async: false,
            data: {
                    "_token": "{{ csrf_token() }}",
                    emp_id: emp_id
                },
            success: function (data) {
                obj = JSON.stringify(data);
               $.each(data,function(index, application ){
                        console.log("Start date" + application.start_date);
                        
                    })
            },
            error: function (xhr, err) {
                alert("readyState: " + xhr.readyState + "\nstatus: " + xhr.status);
                alert("responseText: " + xhr.responseText);
            }
        });*/
        $('#calendar').fullCalendar({
            header: {
              left: 'prev,next',
              center: 'title',
              right: 'year,month,basicWeek,basicDay'

            },
            timezone: 'local',
            height: "auto",
            selectable: false,
            dragabble: false,
            defaultView: 'month',
            yearColumns: 2,
            durationEditable: false,
            bootstrap: true,
            
            events: function(start, end, timezone, callback) {
                $.ajax({
                    url: '/employee-calendar',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                       "_token": "{{ csrf_token() }}",
                        emp_id: emp_id
                    },
                    success: function(data) {
                        var events = [];
                        $.each( data ,function(index, application ){
                            var reason = application.reason;
                            if(application.reason.length > 10 ){
                                 reason = application.reason.slice(0,10);
                            }
                            events.push({
                                title:reason,
                                start: application.start_date,
                                end: application.end_date,
                                hr_status :  application.hr_status,
                                allDay: true
                            });
                        });
                        
                        callback(events);
                    }
                });
            },
             eventRender: function(event, element) {
                var today = new Date().toISOString().slice(0,10);               
                var end_date = new Date(event.end).toISOString().slice(0,10);
                
                if(event.hr_status=='1' || event.hr_status=='3') {
                    element.css('background-color', '#BC375A');
                }
                else{
                    element.css('background-color', '#30C76F');
                }
            },
            eventDataTransform: function(event) {                                                                                                                                
                if(event.allDay) {                                                                                                                                               
                    event.end = moment(event.end).add(1, 'days')                                                                                                                 
                }
                return event;  
            }                                                                                                                                                  
        });
        
    }
   </script>
@endpush
