@extends('layouts.master')
@push('css')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
<style type="text/css">
    label{
        font-weight: 600;
    }
    .unread_feedback{
        background: rgba(34, 41, 47, 0.05) !important;
    }

</style>
@endpush
@section('content')
<div class="content-wrapper">
    <div class="content-header row">
    </div>
    <div class="content-body">
        <!-- Dashboard Ecommerce Starts -->
        <section id="dashboard-ecommerce">
            @if(Auth::user()->role == 1)
            <div class="row">
                <div class="col-lg-3 col-sm-6 col-12">
                    <div class="card">
                        <div class="card-header d-flex flex-column align-items-start pb-0">
                            <div class="avatar bg-rgba-primary p-50 m-0">
                                <div class="avatar-content">
                                    <i class="feather icon-users text-primary font-medium-5"></i>
                                </div>
                            </div>
                            <a href="{{ url('employee') }}"><h2 class="text-bold-700 mt-1">{{ $employee }}</h2></a>
                            <p class="mb-0">Employee</p>
                        </div>
                        <div class="card-content">
                            <div id="line-area-chart-1"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 col-12">
                    <div class="card">
                        <div class="card-header d-flex flex-column align-items-start pb-0">
                            <div class="avatar bg-rgba-success p-50 m-0">
                                <div class="avatar-content">
                                    <i class="feather icon-credit-card text-success font-medium-5"></i>
                                </div>
                            </div>
                            <a href="{{ url('departments') }}"><h2 class="text-bold-700 mt-1">{{ $department }}</h2></a>
                            <p class="mb-0">Department</p>
                        </div>
                        <div class="card-content">
                            <div id="line-area-chart-2"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 col-12">
                    <div class="card">
                        <div class="card-header d-flex flex-column align-items-start pb-0">
                            <div class="avatar bg-rgba-danger p-50 m-0">
                                <div class="avatar-content">
                                    <i class="fa fa-paper-plane-o text-danger font-medium-5"></i>
                                </div>
                            </div>
                            <a href="{{ url('leave-application') }}"><h2 class="text-bold-700 mt-1">{{ $leave_application }}</h2></a>
                            <p class="mb-0">Leave Application</p>
                        </div>
                        <div class="card-content">
                            <div id="line-area-chart-3"></div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 col-12">
                    <div class="card">
                        <div class="card-header d-flex flex-column align-items-start pb-0">
                            <div class="avatar bg-rgba-warning p-50 m-0">
                                <div class="avatar-content">
                                    <i class="feather icon-package text-warning font-medium-5"></i>
                                </div>
                            </div>
                            <a href="{{ url('departments') }}"><h2 class="text-bold-700 mt-1">{{ $task_count }}</h2></a>
                            <p class="mb-0">Pending Task</p>
                        </div>
                        <div class="card-content">
                            <div id="line-area-chart-4"></div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header" style="background: #00a1b5;text-align:center;"><h3 style="color: #fff;margin-top: -12px;">Notice Board</h3></div>
                        <form>
                            <div class="card-body row">
                                @foreach($notices as $notice)
                                <div class="col-md-6">
                                    <div class="card text-center mb-3 border-success">
                                        <div class="card-title">{{$notice->title}}</div>
                                        <hr style="margin-top: 0;margin-bottom: 0;">
                                        <div class="card-body">
                                            <p>{{$notice->short_description}}</p>
                                            <a href="javascript:void(0)" onclick="showNotice({{ json_encode($notice) }})" class="btn btn-outline-primary btn-sm waves-effect">Read More</a>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            
                        </form>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header" style="background: #00a1b5;text-align:center;"><h3 style="color: #fff;margin-top: -12px;">Sticky note</h3></div>
                        <form method="POST" action="{{ url('sticky-note-update') }}">
                            @csrf
                            <div class="card-body">
                                <textarea class="form-control summernote" name="sticky_note">{{ ( $sticky_note ) ? $sticky_note->note : '' }}</textarea>
                            </div>
                            <div class="card-footer" style="text-align: right;">
                                <button class="btn btn-primary" type="submit">Update</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!-- Dashboard Ecommerce ends -->

        <div class="modal fade text-left" id="webPopUp" aria-labelledby="myModalLabel17" style="display: none;" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        {{-- <h4 class="modal-title" id="myModalLabel17">Large Modal</h4> --}}
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="pop_info" style="text-align: center;">
                            <h2>Dear {{ Auth::user()->name }}</h2>
                            <p>Please Sign In</p>
                            <a href="{{ url('sign-in-out') }}" onclick="return confirm('are you sure, you want yo do this? ')" class="btn btn-success" style="color: #fff;padding-left: 40px;padding-right: 40px;">Signing In</a>

                             <img style="margin-top: 15px;" src="https://www.engineering.iastate.edu/ecs/files/2013/07/Step9_Signing-Contract.png">
                        </div>
                         <div class="container">
                         </div>
                    </div>
                    
                </div>
            </div>
        </div>
        {{-- Notice Modal --}}
        <!-- Modal -->
        <div class="modal fade text-left" id="noticeModal" role="dialog" aria-labelledby="myModalLabel17" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form method="POST" action="{{ url('notice-board') }}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                           <div class="form-group">
                               <label>Short Description: </label>
                               <p id="short_description"></p>
                           </div>
                           <div class="form-group">
                               <label>Long Description: </label>
                               <div id="description"></div>
                           </div>
                            
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" data-dismiss="modal" aria-label="Close"><i class="fa fa-cancel"></i> Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sigin Modal -->
        <div class="modal fade text-left" id="signInModal" role="dialog" aria-labelledby="signInModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content" style="height: 415px !important; width: 415px !important;">
                    <div class="modal-header">
                        <h4 class="modal-title" id="title"></h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div style="text-align: center;">
                            <a style="margin-top: 100px;" href="{{ url('sign-in-out') }}" onclick="return confirm('are you sure, you want yo do this? ')" class="btn btn-success" style="color: #fff;">Sign In</a> 
                        </div> 
                        <div style="margin-top:20px;text-align: center; font-weight: bold;">Please do sign in, if you are not already!!!</div>
                    </div>     
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" data-dismiss="modal" aria-label="Close"><i class="fa fa-cancel"></i> Close</button>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@php
    $sign_in_out = Auth::user()->current_day_sign_in_out;
@endphp
@endsection
@push('js')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script type="text/javascript">
    $(document).ready(function(){        
        $('.summernote').summernote({
            height: 300,
        });       
    });

    function showNotice(notice){
        $('#noticeModal').modal('show')
        $('#title').html(notice.title)
        $('#short_description').html(notice.short_description)
        $('#description').html(notice.description)
    }
</script>
@endpush
