<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeHolidayHistory extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employee_holiday_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_holiday_id')->index()->comment("PK Of employee_holidays table");
            $table->foreign('employee_holiday_id')->references('id')->on('employee_holidays')->onDelete('cascade');
            $table->unsignedBigInteger('leave_application_id')->index()->comment("PK Of leave_applications table");
            $table->foreign('leave_application_id')->references('id')->on('leave_applications')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_holiday_history');
    }
}
