<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveApplicationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('leave_applications', function (Blueprint $table) {
            $table->id();
            $table->integer('emp_id')->unsigned();
            $table->tinyInteger('type')->comment('1 = Casual Leave, 2 = Medical Leave');
            $table->date('application_date');
            $table->date('start_date');
            $table->date('end_date');
            $table->text('reason')->nullable();
            $table->tinyInteger('dp_status')->comment('1 = Pending, 2 = Approved, 3 = Declined')->default(1);
            $table->tinyInteger('dp_approved_by')->nullable();
            $table->date('dp_approved_date')->nullable();
            $table->tinyInteger('hr_status')->comment('1 = Pending, 2 = Approved, 3 = Declined')->default(1);
            $table->tinyInteger('hr_approved_by')->nullable();
            $table->date('hr_approved_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('leave_applications');
    }
}
