<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWarningLettersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('warning_letters', function (Blueprint $table) {
            $table->id();
            $table->integer('emp_id')->unsigned()->comment('primary key of employee table');
            $table->tinyInteger('warning_no')->nullable();
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $table->string('doc_name')->nullable();
            $table->string('doc')->nullable();
            $table->tinyInteger('status')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('warning_letters');
    }
}
