<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTaskFeedbackTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('task_feedback', function (Blueprint $table) {
            $table->id();
            $table->integer('task_id')->unsigned()->comment('primary key of task table');
            $table->text('description')->nullable();
            $table->text('attach_name')->nullable();
            $table->text('sender_name')->nullable();
            $table->text('attach')->nullable();
            $table->text('created_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('task_feedback');
    }
}
