<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTasksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */    
    public function up()
    {
        Schema::create('tasks', function (Blueprint $table) {
            $table->id();
            //$table->text('title')->nullable();
            $table->integer('client_id')->nullable();
            $table->longText('description')->nullable();
            $table->integer('project_id')->nullable()->comment('primary key of project table');
            // $table->string('emp_id')->nullable()->comment('primary key of employee table');
            //$table->tinyInteger('type')->default(1);
            $table->string('email_files', '3')->default('No');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->date('done_date')->nullable();
            $table->integer('created_by')->nullable()->comment('primary key of user table');
            $table->tinyInteger('status')->comment('1 = Pending', '2 = complete')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tasks');
    }
}
