<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->string('user_id')->unsinged()->coomment('primary key of user table');
            $table->string('type')->nullable();
            $table->string('name')->nullable();
            $table->string('phone')->nullable();
            $table->string('office_phone')->nullable();
            $table->string('per_email')->nullable();
            $table->string('office_email')->nullable();
            $table->string('pre_address')->nullable();
            $table->string('mailing_address')->nullable();
            $table->string('per_address')->nullable();
            $table->string('maritial_status')->nullable();
            $table->string('gender')->nullable();
            $table->string('religion_status')->nullable();
            $table->string('f_name')->nullable();
            $table->string('f_nid')->nullable();
            $table->string('m_name')->nullable();
            $table->string('m_nid')->nullable();
            $table->string('spouse_name')->nullable();
            $table->string('spouse_nid')->nullable();
            $table->string('number_of_child')->nullable();
            $table->string('dob')->nullable();
            $table->string('department_id')->nullable();
            $table->string('designastion')->nullable();
            $table->string('date_of_joining')->nullable();
            $table->text('education')->nullable();
            $table->text('status')->default(1)->comment("1 = Active, 2 = Deactivated, 3 = Block");
            $table->string('photo')->nullable();
            //emergency contact
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employees');
    }
}
