<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\User;

class TaskFeedback extends Model
{
    public function user(){
        return $this->belongsTo(User::class, 'created_by')->withDefault();
    }
    public function getCreatedAtAttribute($date){
        return date('d M y h:i a', strtotime($date));
    }
    public function attachment(){
        return $this->hasMany(TaskFeedbackDoc::class, 'task_feedback_id');
    }
}
