<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use App\User;
use Auth;

class Task extends Model
{
    use LogsActivity;

    public function employee(){
        return $this->belongsToMany(Employee::class);
    }

    public function user(){
        return $this->belongsTo(User::class, 'created_by')->withDefault();
    }

    public function employee_task(){
        return $this->hasMany(EmployeeTask::class, 'task_id');
    }

    public function project(){
        return $this->belongsTo(Project::class, 'project_id')->withDefault();
    }

    public function task_doc(){
        return $this->hasOne(TaskDoc::class, 'task_id');
    }

    public function task_docs(){
        return $this->hasMany(TaskDoc::class, 'task_id');
    }

    public function task_feedback(){
        return $this->hasMany(TaskFeedback::class, 'task_id');
    }

    // public function task_feedback_assign_seen(){
    //     return $this->hasMany(TaskFeedback::class, 'task_id')->whereNull('assign_seen');
    // }

    // public function task_collaborator_seen(){
    //     return $this->hasMany(TaskFeedback::class, 'task_id')->whereNull('collaborator_seen');
    // }

    public function unread_feedback(){
        return $this->hasMany(TaskFeedbackSeen::class, 'task_id')->where('is_seen', 0)->where('user_id', Auth::user()->employee->id);
    }

    public function task_feedback_seen(){
        return $this->hasMany(TaskFeedbackSeen::class, 'task_id');
    }
}
