<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\User;

class LeaveApplication extends Model
{
    protected $fillable = ['emp_id','type', 'application_date','start_date','previous_start_date','end_date','previous_end_date','reason','dp_status','dp_approved_by','dp_approved_date','hr_status','hr_approved_by','hr_approved_date','application_date_changed_by'];    	

    public function employee(){
    	return $this->belongsTo(Employee::class, 'emp_id');
    }

    public function dp_head(){
    	return $this->belongsTo(User::class, 'dp_approved_by');
    }

    public function hr_user(){
    	return $this->belongsTo(User::class, 'hr_approved_by');
    }
    
}
