<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\Traits\LogsActivity;
use App\Models\Project;
use App\User;

class Employee extends Model
{
    use LogsActivity;
    public function emg_contact(){
    	return $this->hasOne(EmployeeEmergency::class, 'employee_id');
    }

    public function user(){
    	return $this->belongsTo(User::class, 'user_id')->withDefault();
    }

    public function task(){
        return $this->belongsToMany(Task::class);
    }

    public function department(){
        return $this->belongsTo(Department::class, 'department_id')->withDefault();
    }

    public function dep_employees(){
        return $this->hasMany(Employee::class, 'department_id', 'department_id');
    }

    public function unread_tasks(){
        return $this->hasMany(TaskFeedbackSeen::class, 'user_id')->where('is_seen', 0);
    }

    public function projects(){
        return $this->belongsToMany(Project::class);
    }

    public function emp_projects(){
        return $this->hasMany(Project::class);
    }

    public function holiday()
    {
        return $this->hasOne(EmployeeHoliday::class);
    }
}
