<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WarningLetter;
use App\Models\Employee;
use Auth;
use DB;
use Toastr;

class WarninLetterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = "Warning Letter";
        $data['menu'] = "warning_letter";
        $data['employess'] = Employee::where('status', 1)->get();
        $warning_letter = WarningLetter::orderBy('id','desc');
        if(Auth::user()->role == 2){
            $warning_letter = $warning_letter->where('emp_id', Auth::user()->id);
        }
        $data['warning_letter'] = $warning_letter->paginate(50);
        return view('pages.warning_letter', $data);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new WarningLetter();
        $data->emp_id = $request->employee;
        $data->warning_no = $request->warning_no;
        $data->title = $request->name ;
        $data->description = $request->description;
        $data->status = $request->status;

        $doc = $request->file('doc');
        if(isset($doc)){
            $data->doc_name = $doc->getClientOriginalName();
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('warning', $doc, $doc_name);
            $data->doc = $doc_name;
        }
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Warning Letter Added');
        return redirect()->back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = WarningLetter::findOrFail($request->warning_letter_id);
        $data->emp_id = $request->employee;
        $data->warning_no = $request->warning_no;
        $data->title = $request->name ;
        $data->description = $request->description;
        $data->status = $request->status;

        $doc = $request->file('doc');
        if(isset($doc)){
            if (Storage::disk('public')->exists('warning/'.$data->doc)) {
                Storage::disk('public')->delete('warning/'.$data->doc);
            }
            $data->doc_name = $doc->getClientOriginalName();
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('warning', $doc, $doc_name);
            $data->doc = $doc_name;
        }
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Warning Letter Added');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = WarningLetter::findOrFail($id);
        if (Storage::disk('public')->exists('warning/'.$data->doc)) {
            Storage::disk('public')->delete('warning/'.$data->doc);
        }

        try {
            $data->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }
        toastr()->success('Successfully Warning Letter Deleted');
        return redirect()->back();
    }
}
