<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Department;
use App\Models\EmployeeEmergency;
use App\Models\EmployeeTask;
use App\Models\Task;
use App\Models\TaskFeedback;
use App\Models\Project;
use App\Models\TaskDoc;
use App\Models\TaskFeedbackSeen;
use App\Models\TaskFeedbackDoc;
use Carbon\Carbon;
use App\User;
use DB;
use Auth;

class TaskController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data['title'] = "Task";
        $data['menu'] = "task";
        $data['request'] = $request;
        $data['users'] = User::all();
        $tasks = Task::with('employee_task','project','task_docs')->orderBy('status', 'asc')->orderBy('id', 'desc');
        if(Auth::user()->role != 1){
            $emp_task = EmployeeTask::where('employee_id', Auth::user()->employee->id)->get()->toArray();
            $ids = array_column($emp_task, 'task_id');
            // dd($ids);
            $assign_tasks = Task::where('created_by', Auth::user()->id)->get()->toArray();
            
            if(count($assign_tasks) > 0){
                foreach($assign_tasks as $value){
                    array_push($ids, $value['id']); 
                }
            }
            $emp_project_ids = Auth::user()->employee->projects? Auth::user()->employee->projects->pluck('id') : '';
            if($emp_project_ids){
                $projects_task_ids = Task::whereIn('project_id', $emp_project_ids)->pluck('id');
                // dd($projects_task_ids);
                if(count($projects_task_ids) > 0){
                    foreach($projects_task_ids as $value){
                        array_push($ids, $value);
                    }
                }                
            }
            $tasks = $tasks->whereIn('id', array_unique($ids));
        }
        if($request->daterange){
            $daterange = explode(' - ', $request->daterange);
            $start_date = ($daterange[0])? date('Y-m-d', strtotime($daterange[0])) : ''; 
            $end_date = ($daterange[1])? date('Y-m-d', strtotime($daterange[1])) : ''; 
            if($start_date && $end_date){
                $tasks = $tasks->whereBetween('start_date', [$start_date, $end_date]);
            }
        }
        if($request->project){
            $tasks = $tasks->where('project_id', $request->project);
        }
        if($request->employee){
            $emp_task = EmployeeTask::where('employee_id', $request->employee)->get()->toArray();
            $ids = array_column($emp_task, 'task_id');
            $tasks = $tasks->whereIn('id', array_unique($ids));
        }
        if($request->asign_by){
            $tasks = $tasks->where('created_by', $request->asign_by);
        }
        if($request->status){
            if($request->status == 5){
                $tasks = $tasks->where('end_date', '<', date('Y-m-d'))->where('status', '!=', 3);
            }else{
                $tasks = $tasks->where('status', $request->status);
            }
        }
        if($request->read_status){
            if($request->read_status == 2){
                $task_id = TaskFeedbackSeen::where('is_seen', 0)->where('user_id', Auth::user()->employee->id)->pluck('task_id');
                $tasks = $tasks->whereIn('id', $task_id);
            }else{
                $task_id = TaskFeedbackSeen::where('is_seen', 0)->pluck('task_id');
                foreach ($task_id as $value) {
                   $tasks = $tasks->where('id', '!=', $value);
                }
            }
        }
        $data['tasks'] = $tasks->paginate(10);
        $data['employee'] = Employee::where('status', 1)->get();
        $data['projects'] = Project::where('status', 1)->get();
        return view('pages.tasks', $data);
        // return view('pages.tasks.index', $data);
    }

  
    public function store(Request $request)
    {
        // dd($request);
        DB::beginTransaction();
        //Task added
        $task = new Task();
        $task->title = $request->name;
        $task->description = $request->description;
        $task->project_id = $request->project;
        $task->type = $request->type;
        $task->start_date = $request->start_date;
        $task->end_date = $request->end_date;
        $task->created_by = Auth::user()->id;

        if($request->email_files)
        {
            $task->email_files = 'Yes';
        }
        //task saved
        try {
            $task->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        //file uploads
        $doc = $request->file('doc');
        if(isset($doc) && count($doc)){
            foreach ($doc as $key => $value) {
                $task_doc = new TaskDoc();
                $task_doc->task_id = $task->id;
                $task_doc->doc_name = $value->getClientOriginalName();
                $doc_name = uniqid().'.'.$value->getClientOriginalExtension();
                Storage::disk('public')->putFileAs('task', $value, $doc_name);
                $task_doc->doc = $doc_name;

                //save doc
                try {
                    $task_doc->save();
                } catch (Exception $e) {
                    DB::rollBack();
                    toastr()->error($e->message());
                    return redirect()->back();
                }
            }
        }

        
        try {
            $task->employee()->sync($request->employee);
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        if($task->employee_task){
            foreach ($task->employee_task as $key => $emp_task) {
                $task_feedback_seen = new TaskFeedbackSeen();
                $task_feedback_seen->task_id = $task->id;
                $task_feedback_seen->user_id = $emp_task->employee_id;
                try {
                    $task_feedback_seen->save();
                } catch (Exception $e) {
                    DB::rollBack();
                    toastr()->error($e->message());
                    return redirect()->back();
                }
            }
        }

        DB::commit();
        toastr()->success('Successfully Task added');
        return redirect()->back();
    }

    public function update(Request $request)
    {
         
        DB::beginTransaction();

        //Task added
        $task = Task::findOrFail($request->task_id);
        if($request->name){
           $task->title = $request->name; 
        }
        
        $task->status = $request->status;
        if($request->status == 3){
            $task->done_date = date('Y-m-d');
        }
        if(Auth::user()->role == 1 || Auth::user()->id == $task->created_by){
            $task->description = $request->description;
            $task->project_id = $request->project;
            $task->start_date = $request->start_date;
            $task->end_date = $request->end_date;
            
        }
        //$task->type = $request->type;
        if($request->email_files)
        {
            $task->email_files = 'Yes';
        }else{            
            $task->email_files = $task->email_files;
        }
        
        try {
            $task->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        //file uploads
        $doc = $request->file('doc');
        if(isset($doc) && count($doc)){
            foreach ($doc as $key => $value) {
                
                $task_doc = new TaskDoc();
                $task_doc->task_id = $task->id;
                $task_doc->doc_name = $value->getClientOriginalName();
                $doc_name = uniqid().'.'.$value->getClientOriginalExtension();
                Storage::disk('public')->putFileAs('task', $value, $doc_name);
                $task_doc->doc = $doc_name;

                //save doc
                try {
                    $task_doc->save();
                } catch (Exception $e) {
                    DB::rollBack();
                    toastr()->error($e->message());
                    return redirect()->back();
                }
            }
        }


        try {
            if($request->employee){
                $task->employee()->sync($request->employee);
            }            
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        if($request->feed_back || $request->file('attach')){
            $task_feedback = new TaskFeedback();
            $task_feedback->task_id = $request->task_id;
            $task_feedback->description = $request->feed_back;
            
            $task_feedback->sender_name = Auth::user()->name;
            $task_feedback->created_by = Auth::user()->id;
            try {
                $task_feedback->save();
            } catch (Exception $e) {
                DB::rollBack();
                toastr()->error($e->message());
                return redirect()->back();
            }


            $attachment = $request->file('attach');
            if(isset($attachment)){
                foreach ($attachment as $attach) {
                    $task_feed_doc = new TaskFeedbackDoc();
                    $task_feed_doc->task_feedback_id = $task_feedback->id;

                    $task_feed_doc->doc_name = $attach->getClientOriginalName();
                    $attach_name = uniqid().'.'.$attach->getClientOriginalExtension();
                    Storage::disk('public')->putFileAs('attach', $attach, $attach_name);
                    $task_feed_doc->doc = $attach_name;
                    try {
                        $task_feed_doc->save();
                    } catch (Exception $e) {
                        DB::rollBack();
                        toastr()->error($e->message());
                        return redirect()->back();
                    }
                }
                
            }

            if($task->employee_task){
                foreach ($task->employee_task as $key => $emp_task) {
                    if(Auth::user()->employee->id != $emp_task->employee_id){
                        $task_feedback_seen = new TaskFeedbackSeen();
                        $task_feedback_seen->task_id = $task->id;
                        $task_feedback_seen->user_id = $emp_task->employee_id;
                        try {
                            $task_feedback_seen->save();
                        } catch (Exception $e) {
                            DB::rollBack();
                            toastr()->error($e->message());
                            return redirect()->back();
                        }
                    }
                    continue;
                }
                if(Auth::user()->employee->id != $task->created_by){
                    $task_feedback_seen = new TaskFeedbackSeen();
                    $task_feedback_seen->task_id = $task->id;
                    $task_feedback_seen->user_id = $task->created_by;
                    try {
                        $task_feedback_seen->save();
                    } catch (Exception $e) {
                        DB::rollBack();
                        toastr()->error($e->message());
                        return redirect()->back();
                    }
                }
            }

        }

        DB::commit();
        toastr()->success('Successfully Task Update');
        return redirect()->back();
    }
    public function update__2021_10_21(Request $request)
    {
        //dd( $request);
        DB::beginTransaction();
        //Task added
        $task = Task::findOrFail($request->task_id);
        $task->title = $request->name;
        $task->status = $request->status;
        if($request->status == 3){
            $task->done_date = date('Y-m-d');
        }
        if(Auth::user()->role == 1 || Auth::user()->id == $task->created_by){
            $task->description = $request->description;
            $task->project_id = $request->project;
            $task->start_date = $request->start_date;
            $task->end_date = $request->end_date;
            
        }
        $task->type = $request->type;
        if($request->email_files)
        {
            $task->email_files = 'Yes';
        }else{
            $task->email_files = 'No';
        }
        
        try {
            $task->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        //file uploads
        $doc = $request->file('doc');
        if(isset($doc) && count($doc)){
            foreach ($doc as $key => $value) {
                
                $task_doc = new TaskDoc();
                $task_doc->task_id = $task->id;
                $task_doc->doc_name = $value->getClientOriginalName();
                $doc_name = uniqid().'.'.$value->getClientOriginalExtension();
                Storage::disk('public')->putFileAs('task', $value, $doc_name);
                $task_doc->doc = $doc_name;

                //save doc
                try {
                    $task_doc->save();
                } catch (Exception $e) {
                    DB::rollBack();
                    toastr()->error($e->message());
                    return redirect()->back();
                }
            }
        }


        try {
            $task->employee()->sync($request->employee);
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        if($request->feed_back || $request->file('attach')){
            $task_feedback = new TaskFeedback();
            $task_feedback->task_id = $request->task_id;
            $task_feedback->description = $request->feed_back;
            
            $task_feedback->sender_name = Auth::user()->name;
            $task_feedback->created_by = Auth::user()->id;
            try {
                $task_feedback->save();
            } catch (Exception $e) {
                DB::rollBack();
                toastr()->error($e->message());
                return redirect()->back();
            }


            $attachment = $request->file('attach');
            if(isset($attachment)){
                foreach ($attachment as $attach) {
                    $task_feed_doc = new TaskFeedbackDoc();
                    $task_feed_doc->task_feedback_id = $task_feedback->id;

                    $task_feed_doc->doc_name = $attach->getClientOriginalName();
                    $attach_name = uniqid().'.'.$attach->getClientOriginalExtension();
                    Storage::disk('public')->putFileAs('attach', $attach, $attach_name);
                    $task_feed_doc->doc = $attach_name;
                    try {
                        $task_feed_doc->save();
                    } catch (Exception $e) {
                        DB::rollBack();
                        toastr()->error($e->message());
                        return redirect()->back();
                    }
                }
                
            }

            if($task->employee_task){
                foreach ($task->employee_task as $key => $emp_task) {
                    if(Auth::user()->employee->id != $emp_task->employee_id){
                        $task_feedback_seen = new TaskFeedbackSeen();
                        $task_feedback_seen->task_id = $task->id;
                        $task_feedback_seen->user_id = $emp_task->employee_id;
                        try {
                            $task_feedback_seen->save();
                        } catch (Exception $e) {
                            DB::rollBack();
                            toastr()->error($e->message());
                            return redirect()->back();
                        }
                    }
                    continue;
                }
                if(Auth::user()->employee->id != $task->created_by){
                    $task_feedback_seen = new TaskFeedbackSeen();
                    $task_feedback_seen->task_id = $task->id;
                    $task_feedback_seen->user_id = $task->created_by;
                    try {
                        $task_feedback_seen->save();
                    } catch (Exception $e) {
                        DB::rollBack();
                        toastr()->error($e->message());
                        return redirect()->back();
                    }
                }
            }

        }

        DB::commit();
        toastr()->success('Successfully Task Update');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Task $task)
    {
        DB::beginTransaction();
        if($task->task_doc){
            if (Storage::disk('public')->exists('task/'.$task->task_doc->doc)) {
                Storage::disk('public')->delete('task/'.$task->task_doc->doc);
            }
            try {
                $task->task_doc->delete();
            } catch (Exception $e) {
                DB::rollBack();
                toastr()->error($e->message());
                return redirect()->back();
            }
        }

        try {
            $task->employee()->detach();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        try {
            $task->task_feedback_seen()->delete();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        try {
            $task->delete();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        DB::commit();
        toastr()->success('Successfully Task Deleted');
        return redirect()->back();
        
    }

    public function task_feedback(Request $request){
        $task = Task::findOrFail($request->task_id);
        
        DB::beginTransaction();
        $task->status = $request->status;
        if($request->status == 3){
            $task->done_date = date('Y-m-d');
        }
        try {
            $task->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        if($request->feed_back || $request->file('attach')){
            $task_feedback = new TaskFeedback();
            $task_feedback->task_id = $request->task_id;
            $task_feedback->description = $request->feed_back;
            
            $task_feedback->sender_name = Auth::user()->name;

            $task_feedback->created_by = Auth::user()->id;

            try {
                $task_feedback->save();
            } catch (Exception $e) {
                DB::rollBack();
                toastr()->error($e->message());
                return redirect()->back();
            }


            $attachment = $request->file('attach');
            if(isset($attachment)){
                foreach ($attachment as $attach) {
                    $task_feed_doc = new TaskFeedbackDoc();
                    $task_feed_doc->task_feedback_id = $task_feedback->id;

                    $task_feed_doc->doc_name = $attach->getClientOriginalName();
                    $attach_name = uniqid().'.'.$attach->getClientOriginalExtension();
                    Storage::disk('public')->putFileAs('attach', $attach, $attach_name);
                    $task_feed_doc->doc = $attach_name;
                    try {
                        $task_feed_doc->save();
                    } catch (Exception $e) {
                        DB::rollBack();
                        toastr()->error($e->message());
                        return redirect()->back();
                    }
                }
                
            }

            if($task->employee_task){
                foreach ($task->employee_task as $key => $emp_task) {
                    if(Auth::user()->employee->id != $emp_task->employee_id){
                        $task_feedback_seen = new TaskFeedbackSeen();
                        $task_feedback_seen->task_id = $task->id;
                        $task_feedback_seen->user_id = $emp_task->employee_id;
                        try {
                            $task_feedback_seen->save();
                        } catch (Exception $e) {
                            DB::rollBack();
                            toastr()->error($e->message());
                            return redirect()->back();
                        }
                    }
                    continue;
                }
                if(Auth::user()->employee->id != $task->created_by){
                    $task_feedback_seen = new TaskFeedbackSeen();
                    $task_feedback_seen->task_id = $task->id;
                    $task_feedback_seen->user_id = $task->created_by;
                    try {
                        $task_feedback_seen->save();
                    } catch (Exception $e) {
                        DB::rollBack();
                        toastr()->error($e->message());
                        return redirect()->back();
                    }
                }
            }

        }
        

        DB::commit();
        toastr()->success('Successfully Task Feedback Added');
        return redirect()->back();
    }

    public function get_feedback_data_by_task_id(Request $request){
        $task_data = Task::find($request->task_id);
        if(count($task_data->unread_feedback)){
            foreach ($task_data->unread_feedback as $key => $value) {
                $value->is_seen = 1;
                $value->save();
            }
        }
        $task_feedback = TaskFeedback::with('user', 'attachment')->where('task_id',$request->task_id)->get();
        if(empty(count($task_feedback))){
            return response()->json(['status' => false, 'message' => 'Task Feedback Not Found', 'data' => [] ]);
        }
        
        return response()->json(['status' => true, 'message' => 'Task Found Found', 'data' => $task_feedback ]);
    }

    public function tasks_docs_destroy(Request $request){
        if(empty($request->task_doc_id)){
            return response()->json(['status' => false, 'message' => 'Task Doc ID Not Found', 'data' => [] ]);
        }

        $task_doc = TaskDoc::find($request->task_doc_id);
        if(empty($task_doc)){
            return response()->json(['status' => false, 'message' => 'Task Doc Not Found', 'data' => [] ]);
        }
        if (Storage::disk('public')->exists('task/'.$task_doc->doc)) {
            Storage::disk('public')->delete('task/'.$task_doc->doc);
        }

        try {
            $task_doc->delete();
        } catch (Exception $e) {
            return response()->json(['status' => false, 'message' => $e->message(), 'data' => [] ]);
        }

        return response()->json(['status' => true, 'message' => 'Task Doc Successfully Deleted', 'data' => [] ]);

    }
}
