<?php

namespace App\Http\Controllers\Setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Project;

class ProjectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = "Project";
        $data['menu'] = "setting";
        $data['sub_menu'] = "project";
        $data['project'] = Project::all();
        return view('pages.settings.project', $data);
    }

    
    public function store(Request $request)
    {
        $data = new Project();
        $data->name = $request->name;
        $data->status = $request->status;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully data saved');
        return redirect()->back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = Project::find($request->project_id);
        $data->name = $request->name;
        $data->status = $request->status;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully data updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Project $project)
    {
        try {
            $project->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully data Deleted');
        return redirect()->back();
    }
}
