<?php

namespace App\Http\Controllers\Setting;

use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EmployeeDoc;
use App\Models\Employee;
use Auth;
use DB;
use Toastr;

class EmployeeDocController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = "Uploads Docs";
        $data['menu'] = "uploads_docs";
        $data['employess'] = Employee::where('status', 1)->get();
        $uploads_docs = EmployeeDoc::orderBy('id', 'desc');
        if(Auth::user()->role != 1){
            $uploads_docs = $uploads_docs->where('emp_id', Auth::user()->employee->id);
        }
        $data['uploads_docs'] = $uploads_docs->paginate(50);
        return view('pages.uploads_docs', $data);
    }

    public function store(Request $request)
    {
        // dd($request);
        $data = new EmployeeDoc();
        $data->emp_id = $request->employee;
        $data->title = $request->name ;
        $data->note = $request->description;

        $doc = $request->file('doc');
        if(isset($doc)){
            $data->doc_name = $doc->getClientOriginalName();
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('attach', $doc, $doc_name);
            $data->doc = $doc_name;
        }
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Uploads Added');
        return redirect()->back();
    }


    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = EmployeeDoc::findOrFail($request->uploads_id);
        $data->emp_id = $request->employee;
        $data->title = $request->name ;
        $data->note = $request->description;

        $doc = $request->file('doc');
        if(isset($doc)){
            if (Storage::disk('public')->exists('attach/'.$data->doc)) {
                Storage::disk('public')->delete('attach/'.$data->doc);
            }
            $data->doc_name = $doc->getClientOriginalName();
            $doc_name = uniqid().'.'.$doc->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('attach', $doc, $doc_name);
            $data->doc = $doc_name;
        }
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Uploads Upadted');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = EmployeeDoc::findOrFail($id);
        if (Storage::disk('public')->exists('attach/'.$data->doc)) {
            Storage::disk('public')->delete('attach/'.$data->doc);
        }

        try {
            $data->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }
        toastr()->success('Successfully Uploads Deleted');
        return redirect()->back();
    }
}
