<?php

namespace App\Http\Controllers\Setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Designation;

class DesignationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = "Designation";
        $data['menu'] = "setting";
        $data['sub_menu'] = "designation";
        $data['designation'] = Designation::all();
        return view('pages.settings.designation', $data);
    }

   
    public function store(Request $request)
    {
        $data = new Designation();
        $data->name = $request->name;
        $data->status = $request->status;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully data saved');
        return redirect()->back();
    }

    
    public function update(Request $request)
    {
        $data = Designation::find($request->designation_id);
        $data->name = $request->name;
        $data->status = $request->status;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully data updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Designation $designation)
    {
        try {
            $designation->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }
        toastr()->success('Successfully data Deleted');
        return redirect()->back();
    }
}
