<?php

namespace App\Http\Controllers\Setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Department;

class DepartmentControiller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = "Department";
        $data['menu'] = "setting";
        $data['sub_menu'] = "departments";
        $data['departments'] = Department::all();
        return view('pages.settings.departments', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new Department();
        $data->name = $request->name;
        $data->status = $request->status;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully data saved');
        return redirect()->back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = Department::find($request->dep_d);
        $data->name = $request->name;
        $data->status = $request->status;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully data updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Department::find($id);
        try {
            $data->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }
        toastr()->success('Successfully data Deleted');
        return redirect()->back();
    }
}
