<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Models\NoticeBoard;
use Auth;
use DB;
use Toastr;

class NoticeBoardController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data['title'] = "Notice Board";
        $data['menu'] = "setting";
        $data['sub_menu'] = "notice_board";
        $data['notice_boards'] = NoticeBoard::orderBy('id', 'desc')->get();
        return view('pages.notice_boards', $data);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new NoticeBoard();
        $data->title = $request->name;
        $data->short_description = $request->short_description;
        $data->description = $request->description ;
        $data->status = $request->status;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Notice Board Added');
        return redirect()->back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $data = NoticeBoard::findOrFail($request->notice_board_id);
        $data->title = $request->name;
        $data->short_description = $request->short_description;
        $data->description = $request->description ;
        $data->status = $request->status;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Notice Board Updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(NoticeBoard $notice_board)
    {
      
        try {
            $notice_board->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }
        toastr()->success('Successfully Notice Board Deleted');
        return redirect()->back();
    }
}
