<?php

namespace App\Http\Controllers\Hris;

use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\LeaveApplication;
use App\Models\Employee;
use Auth;
use DB;
use Toastr;

class LeaveApplicationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data['title'] = "Holiday Application";
        $data['menu'] = "leave_application";
        $data['request'] = $request;
        $data['employees'] = Employee::all();
        $leave_application = LeaveApplication::orderBy('id', 'desc')->where('emp_id', Auth::user()->employee->id);
        // if(Auth::user()->role != 1){
        //     if(Auth::user()->employee){
        //         $leave_application = $leave_application->where('emp_id', Auth::user()->employee->id);
        //     }
        // }
        if($request->daterange){
            $daterange = explode(' - ', $request->daterange);
            $start_date = ($daterange[0])? date('Y-m-d', strtotime($daterange[0])) : ''; 
            $end_date = ($daterange[1])? date('Y-m-d', strtotime($daterange[1])) : ''; 
            if($start_date && $end_date){
                $leave_application = $leave_application->whereBetween('application_date', [$start_date, $end_date]);
            }
            $data['date_show'] = ($start_date == $end_date)? date('M d y', strtotime($start_date)) : date('M d y', strtotime($start_date)) .' - '. date('M d y', strtotime($end_date));
        }
        // if($request->employee){
        //     $leave_application = $leave_application->where('emp_id', $request->employee);
        // }
        if($request->dp_status){
            $leave_application = $leave_application->where('dp_status', $request->dp_status);
        }
        if($request->hr_status){
            $leave_application = $leave_application->where('hr_status', $request->hr_status);
        }
        //$left_holiday = ( Auth::user()->employee->holiday ? Auth::user()->employee->holiday->holiday : 0 );
        $left_holiday = 0;
        if( Auth::user()->employee->holiday ){
            $left_holiday = ( Auth::user()->employee->holiday->holiday - Auth::user()->employee->holiday->used_holiday );
        }
         
        $data['leave_application'] = $leave_application->paginate(20);
        $data['left_holiday'] = $left_holiday;
        return view('pages.hris.leave_application', $data);
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {    	
        if($request->start_date > $request->end_date){
    		Toastr::error('', 'Please end you end date less then star date');
    		return redirect()->back();
    	}
    	if(empty(Auth::user()->employee)){
    		Toastr::error('', 'Employee Not Found in this user');
    		return redirect()->back();
    	}

        $data = new LeaveApplication();
        $data->emp_id = Auth::user()->employee->id;
        $data->type = $request->type;
        $data->application_date = date('Y-m-d');
        $data->start_date = $request->start_date;
        $data->end_date = $request->end_date;
        $data->hr_status = 1;
        $data->reason = $request->reason;

        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Leave Application Added');
        return redirect()->back();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
       
        //$leaveApplication = $request->all();
        // role = 1 is Admin, role = 4 is Hr; And they have same rights
        if(Auth::user()->role == 1 || Auth::user()->role == 4){
            //$leaveApplication['hr_approved_by'] = Auth::user()->id;
        }
        // role = 3 is Dp Head
        else if(Auth::user()->role == 1 || Auth::user()->role == 4 || Auth::user()->role == 3){
            //$leaveApplication['dp_approved_by'] = Auth::user()->id;
        }   
        try {            
            $leaveApplicationObj = LeaveApplication::findOrFail($request->leave_application_id); 

            $previous_date_leaveApplication = LeaveApplication::find($request->leave_application_id)->where('start_date', '=', $request->start_date)
                ->where('end_date', '=', $request->end_date)->get(); 
               
            if(!sizeof($previous_date_leaveApplication)){
                $leaveApplication_data['application_date_changed_by'] = Auth::user()->id;
                $leaveApplication_data['previous_start_date'] = $leaveApplicationObj->start_date;
                $leaveApplication_data['previous_end_date'] = $leaveApplicationObj->end_date;
            }
            $leaveApplication_data['start_date'] = $request->start_date;
            $leaveApplication_data['end_date'] = $request->end_date;

            $leaveApplication_data['dp_status'] = $request->dp_status;            
            if(isset($request->hr_status)){
                $leaveApplication_data['hr_status'] = $request->hr_status;
            }            
            $update = DB::table('leave_applications')->where('id', $request->leave_application_id)->update($leaveApplication_data);   

            $start_date = \Carbon\Carbon::createFromFormat('Y-m-d', $leaveApplicationObj->start_date);

            $end_date = \Carbon\Carbon::createFromFormat('Y-m-d', $leaveApplicationObj->end_date);

            $total_requested_days = (($start_date->diffInDays($end_date) + 1) > 0)? ($start_date->diffInDays($end_date) + 1) : 1 ;   
            if($request->dp_status=='2' && $request->hr_status=='2' && $update ){

                DB::table('employee_holidays')->where('employee_id', $leaveApplicationObj->emp_id)->update(array('used_holiday' => DB::raw('used_holiday + ' .$total_requested_days) ));
            }           
           
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Leave Application Updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = LeaveApplication::findOrFail($id);
        try {
            $data->delete();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }
        toastr()->success('Successfully Leave Application Deleted');
        return redirect()->back();
    }
    public function employeeCalendar( Request $resuest){
       $leave_application = LeaveApplication::orderBy('id', 'desc')->where('emp_id', $resuest->emp_id)->get();
       return  $leave_application;
    }
    public function leave_notify(Request $request){
        $data['title'] = "Holiday Application";
        $data['menu'] = "leave_notify";
        $data['request'] = $request;
        $data['employees'] = Employee::all();
        $leave_applications = LeaveApplication::orderBy('id', 'desc');


        if($request->daterange){
            $daterange = explode(' - ', $request->daterange);
            $start_date = ($daterange[0])? date('Y-m-d', strtotime($daterange[0])) : ''; 
            $end_date = ($daterange[1])? date('Y-m-d', strtotime($daterange[1])) : ''; 
            if($start_date && $end_date){
                $leave_applications = $leave_applications->whereBetween('application_date', [$start_date, $end_date]);
            }
            $data['date_show'] = ($start_date == $end_date)? date('M d y', strtotime($start_date)) : date('M d y', strtotime($start_date)) .' - '. date('M d y', strtotime($end_date));
        }
        if($request->employee){
            $leave_applications = $leave_applications->where('emp_id', $request->employee);
        }
        if($request->dp_status){
            $leave_applications = $leave_applications->where('dp_status', $request->dp_status);
        }
        if($request->hr_status){
            $leave_applications = $leave_applications->where('hr_status', $request->hr_status);
        }
        if(Auth::user()->role == 1 || Auth::user()->role == 3 || Auth::user()->role == 4){
            $data['leave_applications'] = $leave_applications->paginate(20);
        }else{
            $data['leave_applications'] = [];
        }
        //dd( $leave_applications);
        //$leave_applications_calendar = LeaveApplication::where('emp_id', Auth::user()->employee->id)->orderBy('id', 'desc');
        //$data['leave_applications_calendar'] = $leave_applications_calendar->get();
        //dd($leave_applications_calendar);
        return view('pages.hris.leave_application_notify', $data);
    }


}//class end
