<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use App\Exports\SignInOurReportExport;
use App\Models\Task;
use App\Models\TaskFeedbackSeen;
use App\Models\EmployeeTask;
use App\Models\Employee;
use App\Models\Department;
use App\Models\Designation;
use App\Models\LeaveApplication;
use App\Models\StickyNote;
use App\Models\NoticeBoard;
use App\Models\Project;
use App\Models\SignInOut;
use Carbon\Carbon;
use Auth;
use App\User;
use DB;
use PDF;
use Image;
use File;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     * @author Sabber Hossain
     * @return void
     */
    public function __construct()
    {         
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     * @author Sabber Hossain
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index(Request $request)
    {
        $data['title'] = 'Dashboard';
        $data['menu'] = 'dashboard';
        $data['request'] = $request;
        $data['users'] = User::all();
        $data['projects'] = Project::where('status', 1)->get();
        $data['department'] = Department::where('status', 1)->count();
        $data['employee'] = Employee::where('status', 1)->count();
        $data['employees'] = Employee::where('status', 1)->get();
        $data['task_count'] = Task::where('status', 1)->count();
        $data['designation'] = Designation::where('status', 1)->count();
        $leave_application = LeaveApplication::orderBy('id', 'desc');
        $data['sticky_note'] = StickyNote::where('user_id', Auth::user()->id)->first();
        $data['notices'] = NoticeBoard::orderBy('created_at', 'asc')->where('status', 1)->get();

        if(Auth::user()->role == 3){
            if(Auth::user()->employee){
                $emp_ids = (Auth::user()->employee->departments)? Auth::user()->employee->departments->pluck('id') : '';
                if($emp_ids){
                    $leave_application = $leave_application->whereIn('emp_id', $emp_ids)->where('dp_status', 1);    
                }
            }
        }
        
        $data['leave_application'] = $leave_application->count();
        // $data['tasks'] = Task::with('employee_task','project','task_feedback')->orderBy('id', 'desc');
        $tasks = Task::with('employee_task','project','task_feedback','task_docs')->orderBy('id', 'desc')->where('status','!=',4);
        
        if(Auth::user()->role != 1){
            
            $emp_task = EmployeeTask::where('employee_id', Auth::user()->employee->id)->get()->toArray();
            $ids = array_column($emp_task, 'task_id');

            $assign_tasks = Task::where('created_by', Auth::user()->id)->get()->toArray();
            
            if(count($assign_tasks) > 0){
                foreach($assign_tasks as $value){
                    array_push($ids, $value['id']); 
                }
            }
            $tasks = $tasks->whereIn('id', array_unique($ids));
        }
        if($request->daterange){
            $daterange = explode(' - ', $request->daterange);
            $start_date = ($daterange[0])?: ''; 
            $end_date = ($daterange[1])?: ''; 
            if($start_date && $end_date){
                $tasks = $tasks->whereBetween('start_date', [$start_date, $end_date]);
            }
        }
        if($request->project){
            $tasks = $tasks->where('project_id', $request->project);
        }
        if($request->employee){
            $emp_task = EmployeeTask::where('employee_id', $request->employee)->get()->toArray();
            $ids = array_column($emp_task, 'task_id');
            $tasks = $tasks->whereIn('id', array_unique($ids));
        }
        if($request->asign_by){
            $tasks = $tasks->where('created_by', $request->asign_by);
        }
        if($request->status){
            if($request->status == 4){
                $tasks = $tasks->where('end_date', '<', date('Y-m-d'))->where('status', '!=', 4);
            }else{
                $tasks = $tasks->where('status', $request->status);
            }
        }
        if($request->read_status){
            if($request->read_status == 2){
                $task_id = TaskFeedbackSeen::where('is_seen', 0)->where('user_id', Auth::user()->employee->id)->pluck('task_id');
                $tasks = $tasks->whereIn('id', $task_id);
            }else{
                $task_id = TaskFeedbackSeen::where('is_seen', 0)->pluck('task_id');
                foreach ($task_id as $value) {
                   $tasks = $tasks->where('id', '!=', $value);
                }
            }
        }
        $data['tasks'] = $tasks->paginate(10);
        return view('home', $data);
    }

    /**
     * Show the application Profile.
     * @author Sabber Hossain
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function profile()
    {
        $data['title'] = 'Dashboard';
        $data['menu'] = 'dashboard';
        $data['user'] = Auth::user();
        $data['employee'] = Auth::user()->employee;
        $data['departments'] = Department::where('status', 1)->get();
        $data['designastion'] = Designation::where('status', 1)->get();
        return view('profile', $data);
    }

    /**
     * user Profile update.
     * @author Sabber Hossain
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function general_info_update(Request $request)
    {
        $user = Auth::user();
        $user->username = $request->username;
        $user->name = $request->name;
        $user->email = $request->email;

        $image = $request->file('image');

        if( !is_string($image) ){
            $dir_path = 'uploads/user_profile';
            $dir_path_resize = 'uploads/user_profile/150x150';
            if (!File::exists($dir_path)){
                File::makeDirectory($dir_path, 0775, true);
            }
            if (!File::exists($dir_path_resize)){
                File::makeDirectory($dir_path_resize, 0775, true);
            }
        }
        if ( !is_string($image) ) { 
            $file = $image;   
            $extension = $file->getClientOriginalExtension(); // getting image                            
            $user->photo = 'file_'.\Carbon\Carbon::now().'.'.$extension; // renaming image
            $file->move($dir_path, $user->photo); // uploading file to given path

            // Start : Image Resize
            //$image = Image::make(public_path($dir_path.'/'.$user->photo));
            // resize the image to a height of 45 and constrain aspect ratio (auto width)
            /*$image->resize(null, 32, function ($constraint) {
                $constraint->aspectRatio();
            });*/
            //$image->save(public_path($dir_path_resize.'/'.$user->photo));
            // End : Image Resize
            //Insert or Update user details table with profile photo name                        
        }   

        try {
            $user->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }
        toastr()->success('Profile General Info Update');
        return redirect()->back();
    }

    /**
     * user password Changw.
     * @author Sabber Hossain
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function change_password(Request $request){
        $user = Auth::user();
        if (!\Hash::check($request->old_pass, $user->password)) {
            toastr()->error('Old Password Not Match');
            return redirect()->back();
        }

        $user->password = bcrypt($request->password);
        $user->temp_password = $request->password;

        try {
            $user->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Password Chnage Successfully');
        return redirect()->back();
    }
    
    /**
     * Employee Info Update.
     * @author Sabber Hossain
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function employee_info_update(Request $request){
        $employee = Auth::user()->employee;
        DB::beginTransaction();
        $employee->type = $request->type;
        $employee->name = $request->name;
        $employee->phone = $request->contact_number;

        $employee->office_phone = $request->office_contact_number;
        $employee->per_email = $request->email;
        $employee->office_email = $request->office_email;
        $employee->pre_address = $request->pre_address;
        $employee->per_address = $request->per_address;
        $employee->maritial_status = $request->marital_status;
        $employee->gender = $request->gender;
        $employee->religion_status = $request->religion;
        $employee->f_name = $request->f_name;
        $employee->f_nid = $request->f_nid;
        $employee->m_name = $request->m_name;
        $employee->m_nid = $request->m_nid;
        $employee->spouse_name = $request->spouse_name;
        $employee->spouse_nid = $request->spouse_nid;
        $employee->dob = $request->dob;
        $employee->department_id = $request->department;
        $employee->designastion = $request->designation;
        $employee->date_of_joining = $request->doj;
        $employee->education = $request->education;
        try {
            $employee->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        $emp_emg = $employee->emg_contact;
        $emp_emg->name = $request->emg_con_name;
        $emp_emg->relation = $request->emg_relation;
        $emp_emg->nid = $request->emg_con_nid;
        $emp_emg->number = $request->emg_con_phone;
        $emp_emg->email = $request->emg_con_email;
        try {
            $emp_emg->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        DB::commit();
        toastr()->success('Successfully Employee added');
        return redirect()->back();
    }
    public function sign_in_out(Request $request, $id = null){       
       
        if($request->sign_in_id){   
            $data = SignInOut::findOrFail($request->sign_in_id); 
            $sign_in = $request->sign_in ?  str_replace("T"," ", $request->sign_in): 00;
            $sign_out = $request->sign_out ? str_replace("T"," ", $request->sign_out
            ): 00;
            
            $time = $request->hour.':'.$request->minute.':00';            
            $time = date('H:i:s', strtotime($time));
            
            if($sign_in){
                $data->sign_in = $sign_in.":00";
            }
            if($sign_out){
                 $data->sign_out = $sign_out.":00";
            }
           
            if($time){
                $data->break_time = $time;
            }
            
            //echo 'sign_in_id'. $request->sign_in_id; 
            //dd($data);
            $data->save();
            //$signInOutUpdated = SignInOut::find($request->sign_in_id)->update($data);
            //dd($data);
            $data = '';
            toastr()->success('Successfully Signing Date Time Updated');
            return redirect()->back();
        }
        if(empty($id)){
            $data = new SignInOut();
            $data->user_id = Auth::user()->id;
            $data->date = date('Y-m-d');
            $data->sign_in = Carbon::now();

            try {
                $data->save();
            } catch (Exception $e) {
                toastr()->error('',$e->message());
                return redirect()->back();
            }
            toastr()->success('Successfully Signing In');
            return redirect()->back();
        }else{
            $time = $request->hour.':'.$request->minute.':00';            
            $time = date('H:i:s', strtotime($time));
            $data = SignInOut::findOrFail($id);
            $data->sign_out = Carbon::now();
            $data->break_time = $time;
            try {
                $data->save();
            } catch (Exception $e) {
                toastr()->error('',$e->message());
                return redirect()->back();
            }
            toastr()->success('Successfully Signing Out');
            return redirect()->back();
        }
    }
    public function sign_in_out_by_admin( Request $request ){
        if( $request->sign_user_id ){
            $data = new SignInOut();

            $sign_in = str_replace("T"," ", $request->sign_in);
            $sign_out = str_replace("T"," ", $request->sign_out
            );       
            $time = $request->hour.':'.$request->minute.':00';            
            $time = date('H:i:s', strtotime($time));
            
            $data->user_id = $request->sign_user_id;
            $data->date = date('Y-m-d');
            $data->sign_in = $sign_in.":00";
            $data->sign_out = $sign_out.":00";
            $data->break_time = $time;
            
            try {
                $data->save();
            } catch (Exception $e) {
                toastr()->error('',$e->message());
                return redirect()->back();
            }
            toastr()->success('Successfully Signing In');
            return redirect()->back();
        }
    }
    //sign_in_out_report
    //sign_in_out_report
    public function sign_in_out_report(Request $request){       
        $data['title'] = "Sign In Sign Out Report";
        $data['title2'] = "Holiday Report";
        $data['request'] = $request;
        $data['menu'] = "hris";
        $data['sub_menu'] = "sign_in_out";
        $data['users'] = User::where('id','!=',1)->get();
        
        $sign_in_out_reports = SignInOut::orderBy('sign_in','desc');

        $leave_application = LeaveApplication::orderBy('id', 'desc')->where('hr_status', '2')->where('dp_status', '2');

        if($request->daterange){
            $daterange = explode(' - ', $request->daterange);

            $start_date = ($daterange[0])? date('Y-m-d', strtotime($daterange[0])) : ''; 
            $end_date = ($daterange[1])? date('Y-m-d', strtotime($daterange[1])) : ''; 
            if($start_date && $end_date){
                $start_date = $start_date." 00:00:00";
                $end_date = $end_date." 23:59:59";
                $sign_in_out_reports = $sign_in_out_reports->whereBetween('sign_in', [$start_date, $end_date]);
                $leave_application = $leave_application->whereBetween('start_date', [$start_date, $end_date]);                
            }
            $data['date_show'] = ($start_date == $end_date)? date('M d y', strtotime($start_date)) : date('M d y', strtotime($start_date)) .' - '. date('M d y', strtotime($end_date));
        }
        if($request->user_id){
            $sign_in_out_reports = $sign_in_out_reports->where('user_id', $request->user_id);
            $user = User::findOrFail($request->user_id);
            if($user && $user->employee){
                $leave_application = $leave_application->where('emp_id',$user->employee->id);
            }else{
                $leave_application ='';
            } 
            
        }       
        if($request->sub_type == 'sign-in-out-export'){
            if(empty($request->user_id)){
                toastr()->error('','Please Select User');
                return redirect()->back();
            }
            $data['user'] = User::findOrFail($request->user_id);
            set_time_limit(300);
            $data['sign_in_out_reports'] = $sign_in_out_reports->get();
            //$sn_dta = $data['sign_in_out_reports'][1];
            
            $pdf = PDF::loadView('pages.report.print.sign_in_out_report_print', $data);
            return $pdf->stream('sign_in_out_report.pdf');
        }else if($request->sub_type == 'holiday-export'){
            if(empty($request->user_id)){
                toastr()->error('','Please Select User');
                return redirect()->back();
            }
            $data['user'] = User::findOrFail($request->user_id);
            set_time_limit(300);
            if($leave_application){
                $data['leave_application'] = $leave_application->get();
            }else{
                $data['leave_application'] = '';
            }
            //$sn_dta = $data['leave_application'][1];
            $pdf = PDF::loadView('pages.report.print.holiday_report_print', $data);
            return $pdf->stream('holiday_report.pdf');
        }
        else{

            $data['sign_in_out_reports'] = $sign_in_out_reports->paginate(20);            
            return view('pages.report.sign_in_out_report', $data);
        }
        
    }
    public function sticky_note_update(Request $request){
        $data = StickyNote::where('user_id', Auth::user()->id)->first();
        if(empty($data)){
            $data = new StickyNote();
            $data->user_id = Auth::user()->id;
        }
        $data->note = $request->sticky_note;
        try {
            $data->save();
        } catch (Exception $e) {
            toastr()->error($e->message());
            return redirect()->back();
        }

        toastr()->success('Successfully Sticky Note Updated');
        return redirect()->back();
    }
}
