<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;
use App\Models\Employee;
use App\Models\Department;
use App\Models\EmployeeHoliday;
use App\Models\Project;
use App\Models\EmployeeEmergency;
use App\Models\Designation;
use App\User;
use DB;
use Auth;

class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data['title'] = "Employee";
        $data['request'] = $request;
        $data['menu'] = "hris";
        $data['sub_menu'] = "employee";
        //$employess = Employee::with('projects:id','holiday')->orderBy('id', 'desc');
        $employess = Employee::with('projects','holiday')->orderBy('id', 'desc');
        $data['departments'] = Department::where('status', 1)->get();
        $data['projects'] = Project::where('status', 1)->get();
        //dd($data['projects']);
        $data['designastion'] = Designation::where('status', 1)->get();
        if($request->type){
            $employess = $employess->where('type', $request->type);
        }
        if($request->name){
            $employess = $employess->where('name', 'LIKE', '%'.$request->name.'%');
        }
        if($request->email){
            $employess = $employess->where('per_email', 'LIKE', '%'.$request->email.'%');
        }
        if($request->phone){
            $employess = $employess->where('office_phone', 'LIKE', '%'.$request->phone.'%');
        }

        $data['employess'] = $employess->paginate(20);
        // dd($data);
        return view('pages.employee', $data);
    }

    public function employeeDeservedHoliday(Request $request){
        $data['title'] = "Employee Deserved Holiday";
        $data['request'] = $request;
        $data['menu'] = "hris";
        $data['sub_menu'] = "employee_deserved_holiday";
        $employess = Employee::with('holiday')->orderBy('id', 'desc');
        
        if($request->type){
            $employess = $employess->where('type', $request->type);
        }
        if($request->name){
            $employess = $employess->where('name', 'LIKE', '%'.$request->name.'%');
        }
        if($request->email){
            $employess = $employess->where('per_email', 'LIKE', '%'.$request->email.'%');
        }
        if($request->phone){
            $employess = $employess->where('office_phone', 'LIKE', '%'.$request->phone.'%');
        }

        $data['employess'] = $employess->paginate(20);
        // dd($data);
        return view('pages.employee_deserved_holiday', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request);
        DB::beginTransaction();
        // user add
        $user =  new User();
        $user->name = $request->name;
        $user->username = $request->username;
        $user->email = $request->email;
        $user->password = bcrypt($request->password);
        $user->temp_password = $request->password;
        $user->role = $request->role;
        $user->status = $request->user_status;
        $user->created_by = Auth::user()->id;
        $image = $request->file('image');
        if(isset($image)){
            $image_name = uniqid().'.'.$image->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('uploads', $image, $image_name);
            $user->photo = $image_name;
        }
        try {
            $user->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }
        // use add end
        // Employee add
        $employee =  new Employee();
        $employee->user_id = $user->id;
        $employee->type = $request->type;
        $employee->name = $request->name;
        $employee->phone = $request->contact_number;
        $employee->office_phone = $request->office_contact_number;
        $employee->per_email = $request->email;
        $employee->office_email = $request->office_email;
        $employee->pre_address = $request->pre_address;
        // $employee->mailing_address = $request->mailing_address;
        $employee->per_address = $request->per_address;
        $employee->maritial_status = $request->marital_status;
        $employee->gender = $request->gender;
        $employee->religion_status = $request->religion;
        $employee->f_name = $request->f_name;
        $employee->f_nid = $request->f_nid;
        $employee->m_name = $request->m_name;
        $employee->m_nid = $request->m_nid;
        $employee->spouse_name = $request->spouse_name;
        $employee->spouse_nid = $request->spouse_nid;
        $employee->dob = $request->dob;
        $employee->department_id = $request->department;
        $employee->designastion = $request->designation;
        $employee->date_of_joining = $request->doj;
        $employee->education = $request->education;
        $employee->status = $request->status;

        try {
            $user = User::find($user->id)->employee()->save($employee);
            //$employee->create();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        try {
            $employee->projects()->sync($request->project_id);
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        // Employee add end

        // Employee Emergency Contact add
        $emp_emg =  new EmployeeEmergency();
        $emp_emg->employee_id = $employee->id;
        $emp_emg->name = $request->emg_con_name;
        $emp_emg->relation = $request->emg_relation;
        $emp_emg->nid = $request->emg_con_nid;
        $emp_emg->number = $request->emg_con_phone;
        $emp_emg->email = $request->emg_con_email;
        try {
            $emp_emg->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }
       // dd($request);
        if(!empty($request->holiday)){
            // Employee holidays add
            $emp_holiday =  new EmployeeHoliday();
            $emp_holiday->employee_id = $employee->id;
            $emp_holiday->holiday = $request->holiday;
            //$emp_holiday->used_holiday = $request->holiday;
            //dd($emp_holiday->used_holiday);
            try {
                $emp_holiday->save();
            } catch (Exception $e) {
                DB::rollBack();
                toastr()->error($e->message());
                return redirect()->back();
            }
        }
        
        DB::commit();
        toastr()->success('Successfully Employee added');
        return redirect()->back();
        // Employee Emergency Contact end

    }

    public function update(Request $request)
    {
        // Employee add
        $employee =  Employee::find($request->employee_id);
        $employee->type = $request->type;
        $employee->name = $request->name;
        $employee->phone = $request->contact_number;

        $employee->office_phone = $request->office_contact_number;
        $employee->per_email = $request->email;
        $employee->office_email = $request->office_email;
        $employee->pre_address = $request->pre_address;
        // $employee->mailing_address = $request->mailing_address;
        $employee->per_address = $request->per_address;
        $employee->maritial_status = $request->marital_status;
        $employee->gender = $request->gender;
        $employee->religion_status = $request->religion;
        $employee->f_name = $request->f_name;
        $employee->f_nid = $request->f_nid;
        $employee->m_name = $request->m_name;
        $employee->m_nid = $request->m_nid;
        $employee->spouse_name = $request->spouse_name;
        $employee->spouse_nid = $request->spouse_nid;
        $employee->dob = $request->dob;
        $employee->department_id = $request->department;
        $employee->designastion = $request->designation;
        $employee->date_of_joining = $request->doj;
        $employee->education = $request->education;
        $employee->status = $request->status;

        $image = $request->file('image');
        if(isset($image)){
            if (Storage::disk('public')->exists('uploads/'.$employee->photo)) {
                Storage::disk('public')->delete('uploads/'.$employee->photo);
            }
            $image_name = uniqid().'.'.$image->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('uploads', $image, $image_name);
            $employee->photo = $image_name;
        }

        try {
            $employee->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        try {
            $employee->projects()->sync($request->project_id);
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }
        // Employee add end

        // Employee Emergency Contact add
        $employee->emg_contact->name = $request->emg_con_name;
        $employee->emg_contact->relation = $request->emg_relation;
        $employee->emg_contact->nid = $request->emg_con_nid;
        $employee->emg_contact->number = $request->emg_con_phone;
        $employee->emg_contact->email = $request->emg_con_email;
        try {
            $employee->emg_contact->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        $employee->user->name = $request->name;
        $employee->user->username = $request->username;
        $employee->user->email = $request->email;
        $employee->user->password = bcrypt($request->password);
        $employee->user->temp_password = $request->password;
        $employee->user->role = $request->role;
        $employee->user->status = $request->user_status;

        $image = $request->file('image');
        if(isset($image)){
            if (Storage::disk('public')->exists('uploads/'.$employee->user->photo)) {
                Storage::disk('public')->delete('uploads/'.$employee->user->photo);
            }
            $image_name = uniqid().'.'.$image->getClientOriginalExtension();
            Storage::disk('public')->putFileAs('uploads', $image, $image_name);
            $employee->user->photo = $image_name;
        }

        try {
            $employee->user->save();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }
        // holiday update
        if(!empty($request->holiday)){
            if($employee->holiday){
                //dd($employee->holiday);
                if($employee->holiday->holiday == $employee->holiday->used_holiday){
                    //DB::rollback();
                    //toastr()->error("You have used holiday already, you can't update, please contact with adminitrator");
                    //return redirect()->back();
                }
                $employee->holiday->holiday = $request->holiday;
                //$employee->holiday->used_holiday = $request->holiday;
                try {
                    $employee->holiday->save();
                } catch (Exception $e) {
                    DB::rollBack();
                    toastr()->error($e->message());
                    return redirect()->back();
                }
            }else{
                $emp_holiday =  new EmployeeHoliday();
                $emp_holiday->employee_id = $employee->id;
                $emp_holiday->holiday = $request->holiday;
                //$emp_holiday->used_holiday = $request->holiday;
                //dd($emp_holiday->used_holiday);
                try {
                    $emp_holiday->save();
                } catch (Exception $e) {
                    DB::rollBack();
                    toastr()->error($e->message());
                    return redirect()->back();
                }
            }
        }
        
        // Employee Emergency Contact end
        DB::commit();
        toastr()->success('Successfully Employee Updated');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Employee $employee)
    {
        DB::beginTransaction();
        try {
            $employee->user->delete();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        try {
            $employee->emg_contact->delete();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }
        // if (Storage::disk('public')->exists('uploads/'.$employee->photo)) {
        //     Storage::disk('public')->delete('uploads/'.$employee->photo);
        // }
        try {
            $employee->delete();
        } catch (Exception $e) {
            DB::rollBack();
            toastr()->error($e->message());
            return redirect()->back();
        }

        DB::commit();
        toastr()->success('Successfully Employee Deleted');
        return redirect()->back();
    }
}
